<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

// END ENQUEUE PARENT ACTION
// 
add_filter( 'wpcf7_validate_text*', 'validate_pan_card', 20, 2 );
function validate_pan_card( $result, $tag ) {
  $tag = new WPCF7_FormTag( $tag );
  if ( 'your-pancard' == $tag->name ) {
      $your_pan = isset( $_POST['your-pancard'] ) ? trim( $_POST['your-pancard'] ) : '';
      if ( 1 !== preg_match ( "/[A-Z]{5}[0-9]{4}[A-Z]/i" , $your_pan) ){
          $result->invalidate( $tag, "PAN Card number is invalid" );
      }
  }
  return $result;
}

add_filter( 'wpcf7_validate_text*', 'validate_gst_number', 20, 2 );
function validate_gst_number( $result, $tag ) {
  $tag = new WPCF7_FormTag( $tag );
  if ( 'your-GST' == $tag->name ) {
      $your_gst = isset( $_POST['your-GST'] ) ? trim( $_POST['your-GST'] ) : '';
      if ( 1 !== preg_match ( "/^([0][1-9]|[1-2][0-9]|[3][0-7])([a-zA-Z]{5}[0-9]{4}[a-zA-Z]{1}[1-9a-zA-Z]{1}[zZ]{1}[0-9a-zA-Z]{1})+$/" , $your_gst) ){
          $result->invalidate( $tag, "GST number is invalid" );
      }
  }
  return $result;
}

add_filter( 'wpcf7_validate_text*', 'validate_aadhaar_number', 20, 2 );
function validate_aadhaar_number( $result, $tag ) {
  $tag = new WPCF7_FormTag( $tag );
  if ( 'owner-aadhar' == $tag->name ) {
      $owner_aadhaar = isset( $_POST['owner-aadhar'] ) ? trim( $_POST['owner-aadhar'] ) : '';
      if ( 1 !== preg_match ( "/^([0-9]){12}$/" , $owner_aadhaar) ){
          $result->invalidate( $tag, "Aadhaar number is invalid" );
      }
  }
  return $result;
}

add_filter( 'wpcf7_validate_text*', 'validate_owner_pan_card', 20, 2 );
function validate_owner_pan_card( $result, $tag ) {
  $tag = new WPCF7_FormTag( $tag );
  if ( 'owner-pan' == $tag->name ) {
      $owner_pan = isset( $_POST['owner-pan'] ) ? trim( $_POST['owner-pan'] ) : '';
      if ( 1 !== preg_match ( "/[A-Z]{5}[0-9]{4}[A-Z]/i" , $owner_pan) ){
          $result->invalidate( $tag, "PAN Card number is invalid" );
      }
  }
  return $result;
}