<?php
class ModelCatalogInformation extends Model {
	public function getInformation($information_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) LEFT JOIN " . DB_PREFIX . "information_to_store i2s ON (i.information_id = i2s.information_id) WHERE i.information_id = '" . (int)$information_id . "' AND id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1'");
	
		return $query->row;
	}
	
	public function getInformations() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) LEFT JOIN " . DB_PREFIX . "information_to_store i2s ON (i.information_id = i2s.information_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1' ORDER BY i.sort_order, LCASE(id.title) ASC");
		
		return $query->rows;
	}
	

				public function addDilInfo($data) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "dil_info SET name = '" . $this->db->escape($data['name']) . "', email = '" . $this->db->escape($data['email']) . "', description = '" . $this->db->escape(strip_tags($data['description'])) . "' , date_added = NOW()");
					
					if ($this->config->get('config_account_mail')) {
						$message  = "New DIL Info \n\n";
						$message .= 'Name: ' . $data['name'] . "\n";
						$message .= 'Email: ' . $data['email'] . "\n";
						$message .= 'Description: ' . $data['description'] . "\n";
						
						$mail->setTo($this->config->get('config_email'));
						$mail->setSubject("New DIL Info");
						$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
						$mail->send();

						// Send to additional alert emails if new account email is enabled
						$emails = explode(',', $this->config->get('config_alert_emails'));

						foreach ($emails as $email) {
							if (strlen($email) > 0 && preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $email)) {
								$mail->setTo($email);
								$mail->send();
							}
						}
					}
				}
			
	public function getInformationLayoutId($information_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information_to_layout WHERE information_id = '" . (int)$information_id . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");
		 
		if ($query->num_rows) {
			return $query->row['layout_id'];
		} else {
			return $this->config->get('config_layout_information');
		}
	}	
	
	public function addDilInfo($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "dil_info SET name = '" . $this->db->escape($data['name']) . "', email = '" . $this->db->escape($data['email']) . "', description = '" . $this->db->escape(strip_tags($data['description'])) . "' , date_added = NOW()");
		
		if ($this->config->get('config_account_mail')) {
			$message  = "New DIL Info \n\n";
			$message .= 'Name: ' . $data['name'] . "\n";
			$message .= 'Email: ' . $data['email'] . "\n";
			$message .= 'Description: ' . $data['description'] . "\n";
			
			$mail->setTo($this->config->get('config_email'));
			$mail->setSubject("New DIL Info");
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();

			// Send to additional alert emails if new account email is enabled
			$emails = explode(',', $this->config->get('config_alert_emails'));

			foreach ($emails as $email) {
				if (strlen($email) > 0 && preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $email)) {
					$mail->setTo($email);
					$mail->send();
				}
			}
		}
	}
}
?>