function onYouTubePlayerReady(playerApiId) {
	var player = document.getElementById(getVideoObjectId(playerApiId));

	player.addEventListener("onStateChange", "onYoutubePlayerStateChange" + getModuleNoFromPlayerApiId(playerApiId));
	
	if (isMuteEnabled(playerApiId)) {
		player.mute();
	}
}

function getModuleNoFromPlayerApiId(playerApiId) {
	var module_no = playerApiId.replace("videoobject", "").replace("m0", "").replace("m1", "");
	
	return module_no;
}

function getVideoObjectId(playerApiId) {
	return "yvb-video-player-" + getModuleNoFromPlayerApiId(playerApiId);
}

function isMuteEnabled(playerApiId) {
	if (playerApiId.indexOf("m1") != -1) {
		return true;
	}
	
	return false;
}