<?php
class ModelModuleRegistrationBonus extends Model {
	
	public function getTotalCustomersByIp($ip){
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE ip='" . $ip . "'";
					
		$query = $this->db->query($sql);

		return $query->row['total'];	
	}
	
	public function addBonus() {
		$this->db->query("INSERT INTO " . DB_PREFIX . "customer_transaction SET customer_id = '" . (int)$this->customer->getId() . "', description = 'Bonus', amount = '" . (float)$this->config->get('registration_bonus_credit_amount') . "', date_added = NOW()");
		$this->sendRBMail('bonus');
	}

	public function addMultipleRegistrationsNotification() {
		$this->sendRBMail('multiple_registration');
	}
	
	public function sendRBMail($mail_type = 'bonus') {
		$find = array(
			'{firstname}',
			'{lastname}',
			'{credit_amount}',
			'{total_credit_amount}',
			'{store_name}',
			'{store_email}',
			'{store_telephone}',
			'{ip}'
		);
		
		$replace = array(
			'firstname'       => $this->customer->getFirstName(),
			'lastname'        => $this->customer->getLastName(),
			'credit_amount'   => $this->currency->format($this->config->get('registration_bonus_credit_amount'), $this->config->get('config_currency')),
			'total_credit'    => $this->currency->format($this->getTransactionTotal($this->customer->getId())),
			'store_name'      => $this->config->get('config_name'),
			'store_email'     => $this->config->get('config_email'),
			'store_telephone' => $this->config->get('config_telephone'),
			'ip'              => $this->request->server['REMOTE_ADDR']
		);
		
		$mail_messages = $this->config->get('registration_bonus_mail');
		$rb_mail_messages = $mail_messages[$this->config->get('config_language_id')];
		
		if ($mail_type == 'bonus') { 
			$subject = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $rb_mail_messages['bonus_mail_subject']))));
			$message = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $rb_mail_messages['bonus_mail_message']))));
		} 
		
		if ($mail_type == 'multiple_registration') { 
			$subject = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $rb_mail_messages['mr_mail_subject']))));
			$message = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $rb_mail_messages['mr_mail_message']))));
		} 
		
		$mail = new Mail(); 
		$mail->protocol = $this->config->get('config_mail_protocol');
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->hostname = $this->config->get('config_smtp_host');
		$mail->username = $this->config->get('config_smtp_username');
		$mail->password = $this->config->get('config_smtp_password');
		$mail->port = $this->config->get('config_smtp_port');
		$mail->timeout = $this->config->get('config_smtp_timeout');			
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender($this->config->get('config_name'));
		$mail->setTo($this->customer->getEmail());
		$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
		$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
		$mail->send();
	}
	
	public function getTransactionTotal($customer_id) {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int)$customer_id . "'");
	
		return $query->row['total'];
	}
}
?>