<?php
class ModelCatalogInformation extends Model {
	public function getInformation($information_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) LEFT JOIN " . DB_PREFIX . "information_to_store i2s ON (i.information_id = i2s.information_id) WHERE i.information_id = '" . (int)$information_id . "' AND id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1'");
	
		return $query->row;
	}
	
	public function getInformations() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) LEFT JOIN " . DB_PREFIX . "information_to_store i2s ON (i.information_id = i2s.information_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1' ORDER BY i.sort_order, LCASE(id.title) ASC");
		
		return $query->rows;
	}
	
	public function getInformationLayoutId($information_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information_to_layout WHERE information_id = '" . (int)$information_id . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");
		 
		if ($query->num_rows) {
			return $query->row['layout_id'];
		} else {
			return $this->config->get('config_layout_information');
		}
	}	
	
	public function addDilInfo($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "dil_info SET company_name = '" . $this->db->escape($data['company_name']) . "',name = '" . $this->db->escape($data['name']) . "', email = '" . $this->db->escape($data['email']) . "',phone = '" . $this->db->escape($data['phone']) . "', description = '" . $this->db->escape(strip_tags($data['description'])) . "' , date_added = NOW()");
		$message  = "Thank You for your Registration, on our website www.diamondindia.net.\n
We have received your details as follows:\n\n";
		$message .= 'Company Name: ' . $data['company_name'] . "\n";
		$message .= 'City Name: ' . $data['name'] . "\n";
		$message .= 'Phone: ' . $data['phone'] . "\n";
		$message .= 'Email: ' . $data['email'] . "\n";
		$message .= "Thank you once Again.\n\n";
		$message .= "Team,\n";
		$message .= "Diamond India Ltd.";
		$mail = new Mail();
		$mail->protocol = $this->config->get('config_mail_protocol');
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->hostname = $this->config->get('config_smtp_host');
		$mail->username = $this->config->get('config_smtp_username');
		$mail->password = $this->config->get('config_smtp_password');
		$mail->port = $this->config->get('config_smtp_port');
		$mail->timeout = $this->config->get('config_smtp_timeout');	
		$mail->setTo('bullionoperations@diamondindia.net');
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender($this->config->get('config_name'));
		$mail->setSubject(html_entity_decode("New DIL Info", ENT_QUOTES, 'UTF-8'));
		$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
		$mail->send();
		$mail->setTo($data['email']);
		$mail->send();
	}
}
?>