<?php

class ModelCatalogAttributeFilter extends Model {		
	public function getAttributesByCategoryId($data = array()){
	
		$cache = md5(http_build_query($data));
		
		$attribute_filter_data = $this->cache->get('attributes.' . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.' . $cache);
	
		if (!$attribute_filter_data) {	
			$sql = "SELECT DISTINCT agd.language_id as agd_lan, ad.language_id as ad_lan, agd.name as group_name, ag.attribute_group_id, ad.name as attribute_name, pa.attribute_id, pa.text as value FROM " . DB_PREFIX . "product_to_category ptc 
					LEFT JOIN " . DB_PREFIX . "product p ON (ptc.product_id = p.product_id)
					LEFT JOIN " . DB_PREFIX . "product_attribute pa ON (ptc.product_id = pa.product_id)
					LEFT JOIN " . DB_PREFIX . "attribute_description ad ON (pa.attribute_id = ad.attribute_id )
					LEFT JOIN " . DB_PREFIX . "attribute a ON (pa.attribute_id = a.attribute_id)
					LEFT JOIN " . DB_PREFIX . "attribute_group ag ON (a.attribute_group_id = ag.attribute_group_id)
					LEFT JOIN " . DB_PREFIX . "attribute_group_description agd ON (ag.attribute_group_id = agd.attribute_group_id)
					WHERE ptc.category_id ='" . (int)$data['category_id'] . "' AND p.status = 1 AND ad.language_id ='" . $this->config->get('config_language_id') . "'
					AND agd.language_id ='" . (int)$this->config->get('config_language_id') ."' AND pa.language_id='" . (int)$this->config->get('config_language_id') . "'";
				
			$implode = array();

			if ($data['selected_attributes']){

				$implode_attributes = array();
				
				$array_filter_attributes = $data['selected_attributes'];
				
				foreach($array_filter_attributes as $attribute_id_attribute_value ){
					$implode_attributes[] = " LOCATE('|" . $attribute_id_attribute_value . "|',  ( SELECT GROUP_CONCAT( CONCAT('|', pa.attribute_id,  '_', pa.text, '|' ) SEPARATOR  ',' ) AS attributes_group FROM " . DB_PREFIX . "product_attribute pa WHERE pa.product_id = p.product_id GROUP BY pa.product_id)) > 0 ";
				}
				
				if ($implode_attributes) {
					$sql .= " AND " . implode(" AND ", $implode_attributes) . " ";
				}
			}	
					
			$sql .= " ORDER BY agd.name, ad.name";
			
			$query = $this->db->query($sql);	
			
			foreach($query->rows as $attribute_group){
				$attribute_group_id = $attribute_group['attribute_group_id'];
				
				if (!isset($attributes_filter_data[$attribute_group_id])){
					
					$attribute_data = array();
					
					foreach($query->rows as $attribute){
						$attribute_id = $attribute['attribute_id'];
						
						if (!isset($attributes_filter_data[$attribute_group_id][$attribute_id]) && $attribute['attribute_group_id'] == $attribute_group_id){
							$values_data = array();
							
							foreach ($query->rows as $attribute_value){
								if (!in_array($attribute_value['value'], $values_data) && $attribute_value['attribute_id'] == $attribute_id){
									$values_data[] = $attribute_value['value'];
								}
							}
							
							$attribute_data[$attribute_id] = array(
								'attribute_id' => $attribute['attribute_id'],
								'name'         => $attribute['attribute_name'],
								'values'       => $values_data
							);
						}	
					}
					
					$attribute_filter_data[$attribute_group_id] = array(
						'group_id'   => $attribute_group['attribute_group_id'],
						'name'       => $attribute_group['group_name'],
						'attributes' => $attribute_data
					);					
			
				}	
			}
			
			$this->cache->set('attributes.' . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.'  . $cache, $attribute_filter_data);
		} 
		
		return $attribute_filter_data;
	}
}
?>