<?php  
class ControllerModuleYoutubeVideoBanner extends Controller {
	protected function index($setting) {
		static $module = 0;
		
		$this->document->addScript('catalog/view/javascript/jquery/jquery.fitvids.js');
		$this->document->addScript('catalog/view/javascript/jquery/youtube_video_banner.js');
    	
		if (file_exists('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/youtube_video_banner.css')) {
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/youtube_video_banner.css');
		} else {
			$this->document->addStyle('catalog/view/theme/default/stylesheet/youtube_video_banner.css');
		}
		
		$this->data['video_id']     = $setting['video_id'];
		$this->data['autoplay']     = $setting['autoplay'];
		$this->data['loop']         = $setting['loop'];
		$this->data['mute']         = $setting['mute'];
		$this->data['show_control'] = $setting['show_control'];
		$this->data['show_mask']    = $setting['show_mask'];
		
		$this->data['title']        = isset($setting['title'][$this->config->get('config_language_id')]) ? html_entity_decode($setting['title'][$this->config->get('config_language_id')], ENT_QUOTES, 'UTF-8') : '';	
		$this->data['subtitle']     = isset($setting['subtitle'][$this->config->get('config_language_id')]) ? html_entity_decode($setting['subtitle'][$this->config->get('config_language_id')], ENT_QUOTES, 'UTF-8') : '';	
		$this->data['description']  = isset($setting['description'][$this->config->get('config_language_id')]) ? html_entity_decode($setting['description'][$this->config->get('config_language_id')], ENT_QUOTES, 'UTF-8') : '';	
		$this->data['button_text']  = isset($setting['button_text'][$this->config->get('config_language_id')]) ? html_entity_decode($setting['button_text'][$this->config->get('config_language_id')], ENT_QUOTES, 'UTF-8') : '';	
		
		$this->data['button_link']  = $setting['button_link'];
		$this->data['opacity']      = $setting['opacity'] / 100;
		
		$show = false;
		$current_route = '';

		if (isset($this->request->get['route'])) {
			$current_route = $this->request->get['route'];	
		}	
		
		if ($setting['show_id']) {
			$this->load->model('design/layout');
			$layout_id = $this->model_design_layout->getLayout($current_route);
			
			if ($setting['layout_id'] == $layout_id && $current_route == 'product/product' && $this->request->get['product_id'] == $setting['show_id']) {
				$show = true;
			}
			
			if ($setting['layout_id'] == $layout_id && $current_route == 'information/information' && $this->request->get['information_id'] == $setting['show_id']) {
				$show = true;
			}
			
			if ($setting['layout_id'] == $layout_id && $current_route == 'product/manufacturer' && ( isset($this->request->get['manufacturer_id']) && $this->request->get['manufacturer_id'] == $setting['show_id'])) {
				$show = true;
			}
			
			if ($setting['layout_id'] == $layout_id && $current_route == 'product/category' && in_array($setting['show_id'], explode("_", $this->request->get['path']))) {
				$show = true;
			}			
			
		} else {
			$show = true;
		}
		
		$this->data['module'] = $module++;
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/youtube_video_banner.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/youtube_video_banner.tpl';
		} else {
			$this->template = 'default/template/module/youtube_video_banner.tpl';
		}
		
		if ($show) {
			$this->render();
		}	
	}
}
?>