<?php
class ControllerModuleSalesMotivator extends Controller {
	protected function index($setting) {
	
		$this->language->load('module/sales_motivator');
		
		$this->load->model('account/customer_group');
		
      	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->document->addScript('catalog/view/javascript/jquery/jquery.salesmotivator.js'); 
		$this->document->addScript('catalog/view/javascript/jquery/colorbox/jquery.colorbox-min.js');
		$this->document->addStyle('catalog/view/javascript/jquery/colorbox/colorbox.css');
		
		if (file_exists('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/sales_motivator.css')) {
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/sales_motivator.css');
		} else {
			$this->document->addStyle('catalog/view/theme/default/stylesheet/sales_motivator.css');
		}
		
		$customer_group = $this->model_account_customer_group->getCustomerGroup($this->config->get('config_customer_group_id'));
		
		if (count($this->config->get('config_customer_group_display')) > 1 ||  $customer_group['company_id_display'] || $customer_group['tax_id_display']) {
			
			// load css to overwrite popup style
			if (file_exists('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/sales_motivator_over.css')) {
				$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/sales_motivator_over.css');
			} else {
				$this->document->addStyle('catalog/view/theme/default/stylesheet/sales_motivator_over.css');
			}
		}
		
		$this->data['text_you_can_get'] = $this->language->get('text_you_can_get');
		$this->data['text_for_friend'] = $this->language->get('text_for_friend');
		$this->data['text_for_share'] = $this->language->get('text_for_share');
		
		$this->data['button_get_discount'] = $this->language->get('button_get_discount');

		$this->data['fb_app_id']     = $this->config->get('sm_fb_app_id');
		$this->data['friend_reward'] = ($this->config->get('sm_friend_reward_type') == 'P') ? $this->config->get('sm_friend_reward') . '%' : $this->currency->format($this->config->get('sm_friend_reward'));
		$this->data['share_reward']  = ($this->config->get('sm_share_reward_type') == 'P') ? $this->config->get('sm_share_reward') . '%' : $this->currency->format($this->config->get('sm_share_reward'));	
		
		$product_id = $this->request->get['product_id'];
		
		$this->data['sm_product_id'] = $product_id;
		
		$this->data['rules_href']= $this->url->link('module/sales_motivator/getRules');
		
		$show = true;
		
		if ($setting['product_id'] && !in_array($product_id, explode(",", str_replace(" ", "", $setting['product_id'])))) {
			$show = false;
		}
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/sales_motivator.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/sales_motivator.tpl';
		} else {
			$this->template = 'default/template/module/sales_motivator.tpl';
		}
		
		if ($show) {
			$this->render();
		}	
	}
	
	public function checkuser() {
		$this->language->load('module/sales_motivator');
		$this->load->model('module/sales_motivator');
		
		$this->session->data['fb_user_info'] = $this->request->post;
		$this->session->data['sm_product_id'] = $this->request->post['sm_product_id'];
		
		if (!$this->model_module_sales_motivator->getTotalCustomersByEmail($this->request->post['email'])) {
			if (!$this->config->get('sm_phone_address_required')) {
				
				$this->createAccount();
				$this->customer->login($this->request->post['email'], '', true);
				$this->showSaleMotivator();
				
			} else {
				$this->accountExtraInfo();
			}			
			
		} else {
		
			if (!$this->customer->isLogged()) {
				$this->customer->login($this->request->post['email'], '', true);
			}
			
			$this->showSaleMotivator();
		}
	}
	
	private function showSaleMotivator() {
		$this->language->load('module/sales_motivator');
		$this->load->model('catalog/product');
		$this->load->model('tool/image');
		
		$json = array();
		
		$this->data['text_share_product']  = $this->language->get('text_share_product');
		$this->data['text_invite_fb_friend'] = $this->language->get('text_invite_fb_friend');
		$this->data['text_like_product']   = $this->language->get('text_like_product');
		$this->data['text_like_fan_page']  = $this->language->get('text_like_fan_page');
		$this->data['text_rules']  = $this->language->get('text_rules');
		$this->data['text_your_invite_link']  = $this->language->get('text_your_invite_link');
		
		$product_id = $this->session->data['sm_product_id'];
		
		$this->data['invite_link'] = str_replace("&amp;", "&", $this->url->link('product/product', 'product_id=' . $product_id . '&invite_id=' . md5($this->customer->getId()), 'SSL'));	
		
		$this->data['fb_fan_page'] = $this->config->get('sm_fb_fan_page');
		
		$product_info = $this->model_catalog_product->getProduct($product_id);
		
		if ($product_info) {
			
			if ($product_info['image']) {
				$this->data['product_image'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height'));
			} else {
				$this->data['product_image'] = $this->model_tool_image->resize('no_image.jpg', $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height'));
			}
			
			$find = array("\"", "\n", "\r");
			$replace = array("&quot;", "", "");
			
			$this->data['product_description'] = str_replace($find, $replace, substr(trim(strip_tags(html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8')), " \t\n\r"), 0, 200) . '...');
			$this->data['product_name'] = $product_info['name'];
					
			if ((float)$product_info['special']) {
				$this->data['product_price'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$this->data['product_price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
			}
		}
		
		$this->data['button_share_now']  = $this->language->get('button_share_now');
		$this->data['button_invite_friend']  = $this->language->get('button_invite_friend');
		$this->data['button_read_rules']  = $this->language->get('button_read_rules');
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/sales_motivator_mc.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/sales_motivator_mc.tpl';
		} else {
			$this->template = 'default/template/module/sales_motivator_mc.tpl';
		}
			
		$json['output'] = $this->render();
		
		$this->response->setOutput(json_encode($json));
	}
	
	public function createAccount() {
		$this->load->model('module/sales_motivator');
		$this->model_module_sales_motivator->addCustomer($this->createOCCustomerData());
	}
	
	public function accountExtraInfo() {
		$this->language->load('module/sales_motivator');
	
		$this->load->model('module/sales_motivator');
		$this->load->model('localisation/country');
		$this->load->model('account/customer_group');
		
		$json = array();
		$show_share_form = false;
		
		if ($this->request->server['REQUEST_METHOD'] == 'POST' && isset($this->request->post['sm_additional_info'])) {
			if (!$json) {
				
				$dinamic_strlen = 'utf8_strlen';
		 
				if ( !function_exists('utf8_strlen') ) {
					$dinamic_strlen = 'strlen';
				}
				
				if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
					$json['error']['warning'] = $this->language->get('error_zone');
				}
				
				$country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);
		
				if ($country_info) {
					if ($country_info['postcode_required'] && ($dinamic_strlen($this->request->post['postcode']) < 2) || ($dinamic_strlen($this->request->post['postcode']) > 10)) {
						$json['error']['warning'] = $this->language->get('error_postcode');
					}
					
					// VAT Validation
					$this->load->helper('vat');
					
					if ($this->config->get('config_vat') && $this->request->post['tax_id'] && (vat_validation($country_info['iso_code_2'], $this->request->post['tax_id']) == 'invalid')) {
						$json['error']['tax_id'] = $this->language->get('error_vat');
					}
				}
				
				if ($this->request->post['country_id'] == '') {
					$json['error']['warning'] = $this->language->get('error_country');
				}				

				if (($dinamic_strlen($this->request->post['city']) < 2) || ($dinamic_strlen($this->request->post['city']) > 128)) {
					$json['error']['warning'] = $this->language->get('error_city');
				}
				
				if (($dinamic_strlen($this->request->post['address_1']) < 3) || ($dinamic_strlen($this->request->post['address_1']) > 128)) {
					$json['error']['warning'] = $this->language->get('error_address_1');
				}
				
				// Customer Group
				$this->load->model('account/customer_group');
				
				if (isset($this->request->post['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($this->request->post['customer_group_id'], $this->config->get('config_customer_group_display'))) {
					$customer_group_id = $this->request->post['customer_group_id'];
				} else {
					$customer_group_id = $this->config->get('config_customer_group_id');
				}

				$customer_group = $this->model_account_customer_group->getCustomerGroup($customer_group_id);
					
				if ($customer_group) {	
					// Company ID
					if ($customer_group['company_id_display'] && $customer_group['company_id_required'] && empty($this->request->post['company_id'])) {
						$json['error']['warning'] = $this->language->get('error_company_id');
					}
					
					// Tax ID 
					if ($customer_group['tax_id_display'] && $customer_group['tax_id_required'] && empty($this->request->post['tax_id'])) {
						$json['error']['warning'] = $this->language->get('error_tax_id');
					}						
				}
				
				if (($dinamic_strlen($this->request->post['telephone']) < 3) || ($dinamic_strlen($this->request->post['telephone']) > 32)) {
					$json['error']['warning'] = $this->language->get('error_telephone');
				}
			}
			
			if (!$json) {
				
				$this->session->data['fb_user_extra_info'] = $this->request->post;
				
				$this->model_module_sales_motivator->addCustomer($this->createOCCustomerData());
				
				$this->customer->login($this->session->data['fb_user_info']['email'], '', true);
				
				$show_share_form = true;
				
				$this->showSaleMotivator();
			}
		
		} else {
		
			$this->data['text_explain_info'] = $this->language->get('text_explain_info');
			$this->data['text_yes'] = $this->language->get('text_yes');
			$this->data['text_no'] = $this->language->get('text_no');
			$this->data['text_select'] = $this->language->get('text_select');
			$this->data['text_none'] = $this->language->get('text_none');
							
			$this->data['entry_telephone'] = $this->language->get('entry_telephone');
			$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
			$this->data['entry_company'] = $this->language->get('entry_company');
			$this->data['entry_company_id'] = $this->language->get('entry_company_id');
			$this->data['entry_tax_id'] = $this->language->get('entry_tax_id');
			$this->data['entry_address_1'] = $this->language->get('entry_address_1');
			$this->data['entry_address_2'] = $this->language->get('entry_address_2');
			$this->data['entry_postcode'] = $this->language->get('entry_postcode');
			$this->data['entry_city'] = $this->language->get('entry_city');
			$this->data['entry_country'] = $this->language->get('entry_country');
			$this->data['entry_zone'] = $this->language->get('entry_zone');
			
			$this->data['button_register'] = $this->language->get('button_register');
		
			$this->data['customer_group_id'] = $this->config->get('config_customer_group_id');
		
			$this->data['customer_groups'] = array();
			
			if (is_array($this->config->get('config_customer_group_display'))) {
				$customer_groups = $this->model_account_customer_group->getCustomerGroups();
				
				foreach ($customer_groups as $customer_group) {
					if (in_array($customer_group['customer_group_id'], $this->config->get('config_customer_group_display'))) {
						$this->data['customer_groups'][] = $customer_group;
					}
				}
			}
			
			$this->data['country_id'] = $this->config->get('config_country_id');
			$this->data['zone_id'] = $this->config->get('config_zone_id');
			
			$this->data['countries'] = $this->model_localisation_country->getCountries();
		
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/sales_motivator_ai.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/module/sales_motivator_ai.tpl';
			} else {
				$this->template = 'default/template/module/sales_motivator_ai.tpl';
			}
			
			$json['output'] = $this->render();
		}
		
		if (!$show_share_form) {
			$this->response->setOutput(json_encode($json));
		}	
	}
	
	public function getRules() {
		$this->language->load('module/sales_motivator');
		
		$all_rules = $this->config->get('sm_rules');
		$rules = html_entity_decode($all_rules[$this->config->get('config_language_id')]['description'], ENT_QUOTES, 'UTF-8');
		
		$find = array(
			'{share_reward}',
			'{friend_reward}',
			'{limit_share_reward}'
		); 
		
		$replace = array(
			'share_reward'       => $this->currency->format($this->config->get('sm_share_reward'), $this->config->get('config_currency')),
			'friend_reward'      => ($this->config->get('sm_friend_reward_type') == 'P') ? $this->config->get('sm_friend_reward') . '%' : $this->currency->format($this->config->get('sm_friend_reward'), $this->config->get('config_currency')),
			'limit_share_reward' => $this->config->get('sm_limit_share_reward')
		);
		
		$rules = str_replace($find, $replace, $rules);
		
		$output  = '<html dir="ltr" lang="en">' . "\n";
		$output .= '<head>' . "\n";
		$output .= '  <title>' . $this->language->get('text_rules') . '</title>' . "\n";
		$output .= '  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">' . "\n";
		$output .= '  <meta name="robots" content="noindex">' . "\n";
		$output .= '</head>' . "\n";
		$output .= '<body>' . "\n";
		$output .= $rules . "\n";
		$output .= '  </body>' . "\n";
		$output .= '</html>' . "\n";			

		$this->response->setOutput($output);
	}
	
	public function createOCCustomerData() {
		
		$this->load->model('module/sales_motivator');
		
		// create customer data in oc format
		$oc_customer_data = array(
			'firstname'  		=> $this->session->data['fb_user_info']['first_name'],
			'lastname'   		=> $this->session->data['fb_user_info']['last_name'],
			'email'      		=> $this->session->data['fb_user_info']['email'],
			'telephone'  		=> isset($this->session->data['fb_user_extra_info']['telephone']) ? $this->session->data['fb_user_extra_info']['telephone'] : '', 
			'fax'        		=> '',
			'password'   		=> $this->model_module_sales_motivator->generateRandomPassword(), 
			'newsletter' 		=> '1',
			'customer_group_id' => isset($this->session->data['fb_user_extra_info']['customer_group_id']) ? $this->session->data['fb_user_extra_info']['customer_group_id'] : $this->config->get('config_customer_group_id'),
			'status'            => '1',
			'approved'          => '1',
			'company'           => isset($this->session->data['fb_user_extra_info']['company']) ? $this->session->data['fb_user_extra_info']['company'] : '',
			'company_id'        => isset($this->session->data['fb_user_extra_info']['company_id']) ? $this->session->data['fb_user_extra_info']['company_id'] : '',
			'tax_id'            => isset($this->session->data['fb_user_extra_info']['tax_id']) ? $this->session->data['fb_user_extra_info']['tax_id'] : '',
			'address_1'         => isset($this->session->data['fb_user_extra_info']['address_1']) ? $this->session->data['fb_user_extra_info']['address_1'] : '', 
			'address_2'         => isset($this->session->data['fb_user_extra_info']['address_2']) ? $this->session->data['fb_user_extra_info']['address_2'] : '', 
			'city'              => isset($this->session->data['fb_user_extra_info']['city']) ? $this->session->data['fb_user_extra_info']['city'] : '', 
			'postcode'          => isset($this->session->data['fb_user_extra_info']['postcode']) ? $this->session->data['fb_user_extra_info']['postcode'] : '', 
			'country_id'        => isset($this->session->data['fb_user_extra_info']['country_id']) ? $this->session->data['fb_user_extra_info']['country_id'] : '', 
			'zone_id'           => isset($this->session->data['fb_user_extra_info']['zone_id']) ? $this->session->data['fb_user_extra_info']['zone_id'] : '', 	
		);
		
		return $oc_customer_data;
	}
	
	public function checkreward() {
		$this->language->load('module/sales_motivator');
		$this->load->model('module/sales_motivator');
		
		$json = array();
		
		if (!$this->model_module_sales_motivator->hasReward()) {
			$go_forward = true;
		
			if ($this->config->get('sm_limit_share_reward') && !$this->model_module_sales_motivator->isTimeShareLimitOK()) {
				$go_forward = false;
			}
			
			if ($go_forward) {
				$this->model_module_sales_motivator->addReward();
				$json['success'] = $this->language->get('text_success_reward');
				
			} else  {
				
				$json['error'] = sprintf($this->language->get('text_error_share_limit'), $this->config->get('sm_limit_share_reward'));
			}
		
		} else {
			$json['error'] = $this->language->get('text_error_already_rewarded');// customer already rewarded for sharing this product
		}
		
		$this->response->setOutput(json_encode($json));
	}
	
	public function invitefriend() {
		$this->language->load('module/sales_motivator');
		
		$json['success'] = $this->language->get('text_success_invite');
		
		$this->response->setOutput(json_encode($json));
	}
	
	public function country() {
		$json = array();
		
		$this->load->model('localisation/country');

    	$country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);
		
		if ($country_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'country_id'        => $country_info['country_id'],
				'name'              => $country_info['name'],
				'iso_code_2'        => $country_info['iso_code_2'],
				'iso_code_3'        => $country_info['iso_code_3'],
				'address_format'    => $country_info['address_format'],
				'postcode_required' => $country_info['postcode_required'],
				'zone'              => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
				'status'            => $country_info['status']		
			);
		}
		
		$this->response->setOutput(json_encode($json));
	}
}
?>