<?php  
class ControllerModuleAttributeFilter extends Controller {
	protected function index() {
		$this->language->load('module/attribute_filter');
		
		$this->load->model('catalog/category');
		$this->load->model('catalog/attribute_filter');
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/stylesheet/attribute_filter.css')) {
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/attribute_filter.css');
		} else {
			$this->document->addStyle('catalog/view/theme/default/stylesheet/attribute_filter.css');
		}
		
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	$this->data['text_reset_filters'] = $this->language->get('text_reset_filters');
		
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}	

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['limit'])) {
			$url .= '&limit=' . $this->request->get['limit'];
		}
		
		if (isset($this->request->get['filter_attributes'])){
			$selected_attributes = preg_split('/\~/', $this->request->get['filter_attributes']);
		} else {
			$selected_attributes = array();
		}
		
		
		$request_path = '';
		
		if (isset($this->request->get['path'])) {
			$request_path = $this->request->get['path'];
			$path = '';
		
			$parts = explode('_', (string)$this->request->get['path']);
		
			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}
									
				$category_info = $this->model_catalog_category->getCategory($path_id);
				
				if ($category_info) {
	       			$this->data['breadcrumbs'][] = array(
   	    				'text'      => $category_info['name'],
						'href'      => $this->url->link('product/category', 'path=' . $path),
        				'separator' => $this->language->get('text_separator')
        			);
				}
			}		
		
			$category_id = array_pop($parts);
		} else {
			$category_id = 0;
		}
		
		$this->data['request_path'] = $request_path . $url;
		$this->data['reset_filters'] = $this->url->link('product/category', 'path=' . $request_path . $url, 'SSL');
		
		$this->data['attribute_filters'] = array();
		
		$data = array(
			'category_id' => $category_id,
			'selected_attributes' => $selected_attributes
		);
		
		$attribute_filters = $this->model_catalog_attribute_filter->getAttributesByCategoryId($data);
		
		if ($attribute_filters) {
			foreach($attribute_filters as $attribute_group){
				
				$attribute_data = array();
				
				foreach($attribute_group['attributes'] as $attribute){
				
					$values_data = array();
					
					foreach($attribute['values'] as $attribute_value){
						$values_data[] = array(
							'value'       => html_entity_decode($attribute_value, ENT_QUOTES, 'UTF-8'),
							'combination' => $attribute['attribute_id'] . '_' . $attribute_value
						);					
					}
						
					$attribute_data[] = array(
						'attribute_id' => $attribute['attribute_id'],
						'name'         => $attribute['name'],
						'values'       => $values_data
					);	
				}
				
				$this->data['attribute_filters'][] = array(
					'group_id'   => $attribute_group['group_id'],
					'name'       => $attribute_group['name'],
					'attributes' => $attribute_data
				);
			}
		}	
		
		$this->data['selected_attributes'] = $selected_attributes;
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/attribute_filter.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/attribute_filter.tpl';
		} else {
			$this->template = 'default/template/module/attribute_filter.tpl';
		}
		
		$this->render();
  	}
}
?>