<?php 
class ControllerInformationSuccess extends Controller {  
	public function index() {
    	$this->language->load('information/success');
  
    	$this->document->setTitle($this->language->get('heading_title'));

		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_information'),
			'href'      => $this->url->link('information/information', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_success'),
			'href'      => $this->url->link('information/success'),
        	'separator' => $this->language->get('text_separator')
      	);
		
		$kyc1 = $this->config->get('config_kyc1');
		
		if (isset($kyc1) && $kyc1 != "") {
			$this->data['kyc1'] = $this->url->link('information/success/kyc1');
		} else {
			$this->data['kyc1'] = "";
		}
		
		$kyc2 = $this->config->get('config_kyc2');
		
		if (isset($kyc2) && $kyc2 != "") {
			$this->data['kyc2'] = $this->url->link('information/success/kyc2');
		} else {
			$this->data['kyc2'] = "";
		}

    	$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_message'] = $this->language->get('text_message');
		
    	$this->data['button_continue'] = $this->language->get('button_continue');
		
		if ($this->cart->hasProducts()) {
			$this->data['continue'] = $this->url->link('checkout/cart', '', 'SSL');
		} else {
			$this->data['continue'] = $this->url->link('information/information', '', 'SSL');
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/dilsuccess.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/dilsuccess.tpl';
		} else {
			$this->template = 'default/template/common/dilsuccess.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());				
  	}

	public function kyc1() {
			$file = DIR_IMAGE.$this->config->get('config_kyc1');
			if (!headers_sent()) {
				if (file_exists($file)) {
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . (basename($file)) . '"');
					header('Expires: 0');
					header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					
					if (ob_get_level()) ob_end_clean();
					
					readfile($file, 'rb');
					exit;
				} else {
					exit('Error: Could not find file ' . $file . '!');
				}
			} else {
				exit('Error: Headers already sent out!');
			}
	}

	public function kyc2() {
			$file = DIR_IMAGE.$this->config->get('config_kyc2');
			if (!headers_sent()) {
				if (file_exists($file)) {
					header('Content-Type: application/octet-stream');
					header('Content-Disposition: attachment; filename="' . (basename($file)) . '"');
					header('Expires: 0');
					header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					
					if (ob_get_level()) ob_end_clean();
					
					readfile($file, 'rb');
					exit;
				} else {
					exit('Error: Could not find file ' . $file . '!');
				}
			} else {
				exit('Error: Headers already sent out!');
			}
	}
}
?>