<?php 
class ControllerInformationAnnualReport extends Controller {
	private $error = array();
	public function index() {  
    	$this->language->load('information/annual_report');
		
		$this->load->model('catalog/annual_report');
		
		$this->data['breadcrumbs'] = array();
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	);
		
		$config_dil = $this->config->get('config_dil');
		
		if (isset($config_dil)) {
			$config_dil = (int)$this->config->get('config_dil');
		} else {
			$config_dil = 0;
		}

		$this->data['annualreport'] = array();

		$annualReport = $this->model_catalog_annual_report->getAnnualReport();
		
		foreach ($annualReport as $annualRep) {
			$this->data['annualreport'][] = array(
				'name' => $annualRep['name'],
				'image' => 'image/'.$annualRep['image'],
			);
		}

		$this->document->setTitle($this->language->get('text_annual_report')); 

  		$this->data['breadcrumbs'][] = array(
    		'text'      => $this->language->get('text_annual_report'),
			'href'      => $this->url->link('information/annual_report'),
    		'separator' => $this->language->get('text_separator')
  		);

  		$this->data['heading_title'] = $this->language->get('text_annual_report');
  		
  		$this->data['button_continue'] = $this->language->get('button_continue');
		
		$this->data['description1'] = '';
  		
		$this->data['continue'] = $this->url->link('common/home');
		
		$this->data['config_dil'] = $config_dil;
		
		$this->data['action'] = $this->url->link('information/annual_report', 'SSL');
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}		
		
		if (isset($this->request->post['company_name'])) {
			$this->data['company_name'] = $this->request->post['company_name'];
		} else {
			$this->data['company_name'] = '';
		}
		
		if (isset($this->request->post['name'])) {
			$this->data['name'] = $this->request->post['name'];
		} else {
			$this->data['name'] = '';
		}
		
		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} else {
			$this->data['email'] = '';
		}
		
		if (isset($this->request->post['phone'])) {
			$this->data['phone'] = $this->request->post['phone'];
		} else {
			$this->data['phone'] = '';
		}
		
		if (isset($this->request->post['description'])) {
			$this->data['description'] = $this->request->post['description'];
		} else {
			$this->data['description'] = '';
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/information/annual_report.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/information/annual_report.tpl';
		} else {
			$this->template = 'lexus_store/template/information/annual_report.tpl';
		}
		
		$this->children = array( 
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'
		);
					
  		$this->response->setOutput($this->render());
  	}
}
?>