<?php   
class ControllerCronSalesMotivator extends Controller {
	public function index() {
		$this->language->load('mail/sales_motivator');		
		$this->load->model('module/sales_motivator');		
		
		if (!isset($this->request->get['secret_code'])){
			echo "You forgot secret code";
			exit;
		}
		
		if ($this->request->get['secret_code'] != $this->config->get('sm_secret_code')){
			echo "Access Denied: Wrong secret code";
			exit;
		}
		
		$customers_to_reward = $this->model_module_sales_motivator->getCustomersForReward();
		
		if ($customers_to_reward) {
			foreach ($customers_to_reward as $customer_info) {
				if ($this->config->get('sm_friend_reward_type') == 'F') {
					$reward_amount = $this->config->get('sm_friend_reward') * count ($customer_info['friends_info']);
				} else {
					$reward_amount = $this->config->get('sm_friend_reward') / 100 * $this->getFriendsOrdersTotal($customer_info['friends_info']);
				}
				
				$description = sprintf($this->language->get('text_friends_helped'), $this->getFriendsListMessage($customer_info['friends_info']));
				
				$this->model_module_sales_motivator->addTransaction($customer_info['customer_id'], $description, $reward_amount);
				$this->model_module_sales_motivator->setAsRewarded($customer_info['friends_info']);
			}
		}	
		
		if ($this->config->get('sm_admin_log')) {
			$this->sendLogToAdmin($customers_to_reward);
		}
		
		// start removed credits
		
		if ($this->config->get('sm_remove_credit_status')) {
			$customers_credit_remove = $this->model_module_sales_motivator->getCustomersForRemoveReward();
			
			if ($customers_credit_remove) {
				foreach($customers_credit_remove as $customer) {
					$this->model_module_sales_motivator->addNegativeTransaction($customer['customer_id'], '', -$customer['credit_remove']);
					$this->model_module_sales_motivator->setShareIDSAsRemoved($customer['expired_share_ids']);
				}
			}
		}
	}

	private function getFriendsListMessage($friends) {
		$message = "\n\n";
		
		foreach($friends as $friend) {
			$message .= $friend['name'] . ' - #' . $friend['order_id'] . "\n";
		}
		
		return $message;
	}
	
	private function getFriendsOrdersTotal($friends) {
		$orders_total = 0;
		
		foreach($friends as $friend) {
			$orders_total += $friend['order_total']; 
		}
		
		return $orders_total;
	}

	private function sendLogToAdmin($customers) {
		
		$message = $this->language->get('text_hi_admin') . "\n\n";
		$message .= $this->language->get('text_below_have') . "\n\n";
		
		if ($customers) {
			foreach($customers as $customer) {
				
				$reward_amount = $this->currency->format($this->config->get('sm_friend_reward') * count ($customer['friends_info']), $this->config->get('config_currency'));
				
				$message .= $customer['firstname'] . ' ' . $customer['lastname'] . ' ( ' . $customer['email'] . ' )  + ' . $reward_amount;
			}
		} else {
			
			$message .= $this->language->get('text_nothing_reward');
		}		
		
		$message .= "\n\n" . $this->language->get('text_disable_log');
		
		$mail = new Mail();
		$mail->protocol = $this->config->get('config_mail_protocol');
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->hostname = $this->config->get('config_smtp_host');
		$mail->username = $this->config->get('config_smtp_username');
		$mail->password = $this->config->get('config_smtp_password');
		$mail->port = $this->config->get('config_smtp_port');
		$mail->timeout = $this->config->get('config_smtp_timeout');
		$mail->setTo($this->config->get('config_email'));
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender($this->config->get('config_name'));
		$mail->setSubject(html_entity_decode($this->language->get('text_log_subject'), ENT_QUOTES, 'UTF-8'));
		$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
		$mail->send();
	}	
}
?>