<?php
class ModelToolHTMLEmail extends Model {
	
	public function getHTMLEmail($language_id, $main_title, $main_message, $source_type = 'text'){

		$this->load->model('tool/image');
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = HTTPS_CATALOG;
		} else {
			$server = HTTP_CATALOG;
		}
		
		$template = new Template();
		
		// page
		$template->data['html_email_page_bg'] = $this->config->get('html_email_page_bg');
		
		// top bar
		$template->data['html_email_top_bar_bg'] = $this->config->get('html_email_top_bar_bg');
		$template->data['html_email_top_bar_text_color'] = $this->config->get('html_email_top_bar_text_color');
		$template->data['html_email_top_bar_link_color'] = $this->config->get('html_email_top_bar_link_color');
		
		// header
		$template->data['html_email_header_bg'] = $this->config->get('html_email_header_bg');
		
		// featured
		$template->data['html_email_featured_bg'] = $this->config->get('html_email_featured_bg');
		$template->data['html_email_featured_text_color'] = $this->config->get('html_email_featured_text_color');
		$template->data['html_email_featured_link_color'] = $this->config->get('html_email_featured_link_color');			
		
		if ($this->config->get('html_email_show_featured')) {
			$template->data['html_email_featured_corner_bg'] = $this->config->get('html_email_featured_bg');
			$template->data['html_email_featured_top_bar_bg'] = $this->config->get('html_email_top_bar_bg');
			$template->data['html_email_featured_header_bg'] = $this->config->get('html_email_header_bg');
			
		} else {
			$template->data['html_email_featured_corner_bg'] = $this->config->get('html_email_page_bg');
			$template->data['html_email_featured_top_bar_bg'] = $this->config->get('html_email_page_bg');
			$template->data['html_email_featured_header_bg'] = $this->config->get('html_email_page_bg');
		}
		
		// main message
		$template->data['html_email_main_bg'] = $this->config->get('html_email_main_bg');
		$template->data['html_email_main_text_color'] = $this->config->get('html_email_main_text_color');
		$template->data['html_email_main_link_color'] = $this->config->get('html_email_main_link_color');			
	
		// footer
		$template->data['html_email_footer_bg'] = $this->config->get('html_email_footer_bg');
		$template->data['html_email_footer_text_color'] = $this->config->get('html_email_footer_text_color');
		$template->data['html_email_footer_link_color'] = $this->config->get('html_email_footer_link_color');					
		
		// subfooter
		$template->data['html_email_subfooter_bg'] = $this->config->get('html_email_subfooter_bg');
		$template->data['html_email_subfooter_text_color'] = $this->config->get('html_email_subfooter_text_color');	

		$template->data['show_featured'] = $this->config->get('html_email_show_featured');
		$template->data['show_footer'] = $this->config->get('html_email_show_footer');
		
		// GET default texts messages
		$default_words = $this->config->get('html_email_default_word');
		
		if (isset($default_words[$language_id])) { 
			$current_language_word = $default_words[$language_id];
		} else {	
			$current_language_word = $default_words[$this->config->get('config_language_id')];
		}	
			
		$template->data['featured_title'] = html_entity_decode($current_language_word['featured_title'], ENT_QUOTES, 'UTF-8');
		$template->data['featured_description'] = html_entity_decode($current_language_word['featured_description'], ENT_QUOTES, 'UTF-8');
		$template->data['button_find_more_info'] = html_entity_decode($current_language_word['find_more_info'], ENT_QUOTES, 'UTF-8');
		$template->data['featured_link'] = $current_language_word['featured_link'];
		$template->data['footer_description'] = html_entity_decode($current_language_word['footer_description'], ENT_QUOTES, 'UTF-8');
		$template->data['text_view_store'] = html_entity_decode($current_language_word['view_store'], ENT_QUOTES, 'UTF-8');
		$template->data['text_contact_us'] = html_entity_decode($current_language_word['contact_us'], ENT_QUOTES, 'UTF-8');
		$template->data['text_my_account'] = html_entity_decode($current_language_word['my_account'], ENT_QUOTES, 'UTF-8');
		$template->data['copyright'] = html_entity_decode($current_language_word['copyright'], ENT_QUOTES, 'UTF-8');
		
		$template->data['store_url'] = $server;
		$template->data['view_store'] = $server;
		$template->data['contact_us'] = $server . 'index.php?route=information/contact';
		$template->data['my_account'] = $server . 'index.php?route=account/account';
		
		$template->data['logo'] = '';
		
		if ($this->config->get('html_email_logo') && file_exists(DIR_IMAGE . $this->config->get('html_email_logo')) && is_file(DIR_IMAGE . $this->config->get('html_email_logo'))) {
			if ($this->config->get('html_email_logo_width') && $this->config->get('html_email_logo_height')) {
				$template->data['logo'] = $this->model_tool_image->resize($this->config->get('html_email_logo'), $this->config->get('html_email_logo_width'), $this->config->get('html_email_logo_height'));		
			} else {
				$template->data['logo'] = $server . 'image/' . $this->config->get('html_email_logo');
			}
		}
		
		$template->data['facebook_link'] = $this->config->get('html_email_fb_link');
		$template->data['twitter_link'] = $this->config->get('html_email_tw_link');
		$template->data['youtube_link'] = $this->config->get('html_email_yt_link');
		
		if ($this->config->get('html_email_facebook_icon') && file_exists(DIR_IMAGE . $this->config->get('html_email_facebook_icon')) && is_file(DIR_IMAGE . $this->config->get('html_email_facebook_icon'))) {
			$template->data['facebook_icon'] = $server . 'image/' . $this->config->get('html_email_facebook_icon');
		} else {
			$template->data['facebook_icon'] = '';
		}
		
		if ($this->config->get('html_email_twitter_icon') && file_exists(DIR_IMAGE . $this->config->get('html_email_twitter_icon')) && is_file(DIR_IMAGE . $this->config->get('html_email_twitter_icon'))) {
			$template->data['twitter_icon'] = $server . 'image/' . $this->config->get('html_email_twitter_icon');
		} else {
			$template->data['twitter_icon'] = '';
		}
		
		if ($this->config->get('html_email_youtube_icon') && file_exists(DIR_IMAGE . $this->config->get('html_email_youtube_icon')) && is_file(DIR_IMAGE . $this->config->get('html_email_youtube_icon'))) {
			$template->data['youtube_icon'] = $server . 'image/' . $this->config->get('html_email_youtube_icon');
		} else {
			$template->data['youtube_icon'] = '';
		}
		
		$template->data['main_title'] = html_entity_decode($main_title, ENT_QUOTES, 'UTF-8');  // html_ent or not ???
		
		if ($source_type == 'text') {
			$main_message = $this->text2Html($main_message);
		}
		
		$template->data['main_message'] = html_entity_decode($main_message, ENT_QUOTES, 'UTF-8');  // html_ent or not ???
		
		$html = $template->fetch('mail/html_email_common.tpl');
		
		return $html;
	}
	
	private function text2Html($message) {
		return str_replace("\n", "<br />", $this->autoLink($message));
	}
	
	private function autoLink($message) {
		return preg_replace('@((https?://)?([-\w]+\.[-\w\.]+)+\w(:\d+)?(/([-\w/_\.]*(\?\S+)?)?)*)@', '<a href="$1">$1</a>', $message);
	}	
}
?>