<?php
class ControllerModuleYoutubeVideoBanner extends Controller {
	private $error = array(); 
	 
	public function index() {   
		$this->language->load('module/youtube_video_banner');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('youtube_video_banner', $this->request->post);		
			
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		$this->data['text_content_top'] = $this->language->get('text_content_top');
		$this->data['text_content_bottom'] = $this->language->get('text_content_bottom');		
		$this->data['text_column_left'] = $this->language->get('text_column_left');
		$this->data['text_column_right'] = $this->language->get('text_column_right');
		
		$this->data['entry_video_id']      = $this->language->get('entry_video_id');
		$this->data['entry_autoplay']      = $this->language->get('entry_autoplay');
		$this->data['entry_loop']          = $this->language->get('entry_loop');
		$this->data['entry_mute']          = $this->language->get('entry_mute');
		$this->data['entry_show_control']  = $this->language->get('entry_show_control');
		$this->data['entry_show_mask']     = $this->language->get('entry_show_mask');
		$this->data['entry_over_video']    = $this->language->get('entry_over_video');
		$this->data['entry_title']         = $this->language->get('entry_title');
		$this->data['entry_subtitle']      = $this->language->get('entry_subtitle');
		$this->data['entry_description']   = $this->language->get('entry_description');
		$this->data['entry_button_text']   = $this->language->get('entry_button_text');
		$this->data['entry_button_link']   = $this->language->get('entry_button_link');
		$this->data['entry_opacity']       = $this->language->get('entry_opacity');
		$this->data['entry_show_id']       = $this->language->get('entry_show_id');
		$this->data['entry_layout']        = $this->language->get('entry_layout');
		$this->data['entry_position']      = $this->language->get('entry_position');
		$this->data['entry_status']        = $this->language->get('entry_status');
		$this->data['entry_sort_order']    = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_module'] = $this->language->get('button_add_module');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
		$this->data['tab_module'] = $this->language->get('tab_module');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['control_mask'])) {
			$this->data['error_control_mask'] = $this->error['control_mask'];
		} else {
			$this->data['error_control_mask'] = array();
		}
		
 		if (isset($this->error['opacity'])) {
			$this->data['error_opacity'] = $this->error['opacity'];
		} else {
			$this->data['error_opacity'] = array();
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/youtube_video_banner', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/youtube_video_banner', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['token'] = $this->session->data['token'];

		$this->data['modules'] = array();
		
		if (isset($this->request->post['youtube_video_banner_module'])) {
			$this->data['modules'] = $this->request->post['youtube_video_banner_module'];
		} elseif ($this->config->get('youtube_video_banner_module')) { 
			$this->data['modules'] = $this->config->get('youtube_video_banner_module');
		}	
				
		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();

		$this->template = 'module/youtube_video_banner.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	protected function validate() {
		
		if (!$this->user->hasPermission('modify', 'module/youtube_video_banner')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (isset($this->request->post['youtube_video_banner_module'])) {
			foreach ($this->request->post['youtube_video_banner_module'] as $key => $value) {	
				if ($value['show_control'] == 1 && $value['show_mask'] == 1) {
					$this->error['control_mask'][$key] = $this->language->get('error_control_mask');
					$this->error['warning'] = sprintf($this->language->get('error_module'), $key);
				}
				
				if ((int)$value['opacity'] < 0 || (int)$value['opacity'] > 100) {
					$this->error['opacity'][$key] = $this->language->get('error_opacity');
					$this->error['warning'] = sprintf($this->language->get('error_module'), $key);
				}	
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>