<?php
class ControllerModuleSalesMotivator extends Controller {
	private $error = array();
	private $version = '2.1'; 
	
	public function install() {
		$this->load->model('module/sales_motivator');
		
		$this->model_module_sales_motivator->createTables();
	}
	
	public function uninstall() {
		$this->load->model('module/sales_motivator');
		
		$this->model_module_sales_motivator->removeTables();
	}	
	
	public function index() {   
		$this->load->language('module/sales_motivator');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('sales_motivator', $this->request->post);		
					
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				 
		$this->data['heading_title'] = $this->language->get('heading_title') . ' ' . $this->version;
		
		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_share_reward'] = $this->language->get('tab_share_reward');
		$this->data['tab_friend_reward'] = $this->language->get('tab_friend_reward');
		$this->data['tab_behaviour'] = $this->language->get('tab_behaviour');
		$this->data['tab_rules'] = $this->language->get('tab_rules');
		$this->data['tab_help'] = $this->language->get('tab_help');
		
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_content_top'] = $this->language->get('text_content_top');
		$this->data['text_content_bottom'] = $this->language->get('text_content_bottom');		
		$this->data['text_column_left'] = $this->language->get('text_column_left');
		$this->data['text_column_right'] = $this->language->get('text_column_right');
		$this->data['text_any_order'] = $this->language->get('text_any_order');
		$this->data['text_order_promoted'] = $this->language->get('text_order_promoted');
		$this->data['text_dont_show_anymore'] = $this->language->get('text_dont_show_anymore');
		$this->data['text_dont_show_product'] = $this->language->get('text_dont_show_product');
		$this->data['text_default_design'] = $this->language->get('text_default_design');
		$this->data['text_custom_design'] = $this->language->get('text_custom_design');
		$this->data['text_fixed'] = $this->language->get('text_fixed');
		$this->data['text_percent'] = $this->language->get('text_percent');
		$this->data['text_percent_product_price'] = $this->language->get('text_percent_product_price');
		
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_fb_app_id'] = $this->language->get('entry_fb_app_id');
		$this->data['entry_secret_code'] = $this->language->get('entry_secret_code');
		$this->data['entry_share_reward_type'] = $this->language->get('entry_share_reward_type');
		$this->data['entry_share_reward'] = $this->language->get('entry_share_reward');
		$this->data['entry_remove_credit_status'] = $this->language->get('entry_remove_credit_status');
		$this->data['entry_remove_credit_days'] = $this->language->get('entry_remove_credit_days');
		$this->data['entry_remove_credit_order_status'] = $this->language->get('entry_remove_credit_order_status');
		$this->data['entry_remove_credit_notification'] = $this->language->get('entry_remove_credit_notification');
		$this->data['entry_friend_reward_type'] = $this->language->get('entry_friend_reward_type');
		$this->data['entry_friend_reward'] = $this->language->get('entry_friend_reward');
		$this->data['entry_friend_order_behaviour'] = $this->language->get('entry_friend_order_behaviour');
		$this->data['entry_order_final_status'] = $this->language->get('entry_order_final_status');
		$this->data['entry_limit_share_reward'] = $this->language->get('entry_limit_share_reward');
		$this->data['entry_fb_fan_page'] = $this->language->get('entry_fb_fan_page');
		$this->data['entry_admin_log'] = $this->language->get('entry_admin_log');
		$this->data['entry_phone_address_required'] = $this->language->get('entry_phone_address_required');
		$this->data['entry_rules'] = $this->language->get('entry_rules');
		
		$this->data['entry_layout'] = $this->language->get('entry_layout');
		$this->data['entry_page_product_id'] = $this->language->get('entry_page_product_id');
		$this->data['entry_position'] = $this->language->get('entry_position');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_module'] = $this->language->get('button_add_module');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['fb_app_id'])) {
			$this->data['error_fb_app_id'] = $this->error['fb_app_id'];
		} else {
			$this->data['error_fb_app_id'] = '';
		}
		
		if (isset($this->error['secret_code'])) {
			$this->data['error_secret_code'] = $this->error['secret_code'];
		} else {
			$this->data['error_secret_code'] = '';
		}
		
		if (isset($this->error['share_reward'])) {
			$this->data['error_share_reward'] = $this->error['share_reward'];
		} else {
			$this->data['error_share_reward'] = '';
		}
		
		if (isset($this->error['remove_credit_days'])) {
			$this->data['error_remove_credit_days'] = $this->error['remove_credit_days'];
		} else {
			$this->data['error_remove_credit_days'] = '';
		}
		
		if (isset($this->error['remove_credit_order_status'])) {
			$this->data['error_remove_credit_order_status'] = $this->error['remove_credit_order_status'];
		} else {
			$this->data['error_remove_credit_order_status'] = '';
		}

		if (isset($this->error['friend_reward'])) {
			$this->data['error_friend_reward'] = $this->error['friend_reward'];
		} else {
			$this->data['error_friend_reward'] = '';
		}	

		if (isset($this->error['order_final_status'])) {
			$this->data['error_order_final_status'] = $this->error['order_final_status'];
		} else {
			$this->data['error_order_final_status'] = '';
		}
		
		if (isset($this->error['limit_share_reward'])) {
			$this->data['error_limit_share_reward'] = $this->error['limit_share_reward'];
		} else {
			$this->data['error_limit_share_reward'] = '';
		}	

		if (isset($this->error['rules'])) {
			$this->data['error_rules'] = $this->error['rules'];
		} else {
			$this->data['error_rules'] = array();
		}		
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/sales_motivator', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/sales_motivator', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['sm_status'])){
			$this->data['sm_status'] = $this->request->post['sm_status'];
		} elseif ( $this->config->get('sm_status')){
			$this->data['sm_status'] = $this->config->get('sm_status');
		} else {
			$this->data['sm_status'] = '';
		}
		
		if (isset($this->request->post['sm_fb_app_id'])){
			$this->data['sm_fb_app_id'] = $this->request->post['sm_fb_app_id'];
		} elseif ( $this->config->get('sm_fb_app_id')){
			$this->data['sm_fb_app_id'] = $this->config->get('sm_fb_app_id');
		} else {
			$this->data['sm_fb_app_id'] = '';
		}
		
		if (isset($this->request->post['sm_secret_code'])){
			$this->data['sm_secret_code'] = $this->request->post['sm_secret_code'];
		} elseif ( $this->config->get('sm_secret_code')){
			$this->data['sm_secret_code'] = $this->config->get('sm_secret_code');
		} else {
			$this->data['sm_secret_code'] = '';
		}

		if (isset($this->request->post['sm_share_reward_type'])){
			$this->data['sm_share_reward_type'] = $this->request->post['sm_share_reward_type'];
		} elseif ( $this->config->get('sm_share_reward_type')){
			$this->data['sm_share_reward_type'] = $this->config->get('sm_share_reward_type');
		} else {
			$this->data['sm_share_reward_type'] = '';
		}
		
		if (isset($this->request->post['sm_share_reward'])){
			$this->data['sm_share_reward'] = $this->request->post['sm_share_reward'];
		} elseif ( $this->config->get('sm_share_reward')){
			$this->data['sm_share_reward'] = $this->config->get('sm_share_reward');
		} else {
			$this->data['sm_share_reward'] = '';
		}
		
		if (isset($this->request->post['sm_remove_credit_status'])){
			$this->data['sm_remove_credit_status'] = $this->request->post['sm_remove_credit_status'];
		} elseif ( $this->config->get('sm_remove_credit_status')){
			$this->data['sm_remove_credit_status'] = $this->config->get('sm_remove_credit_status');
		} else {
			$this->data['sm_remove_credit_status'] = '';
		}
		
		if (isset($this->request->post['sm_remove_credit_days'])){
			$this->data['sm_remove_credit_days'] = $this->request->post['sm_remove_credit_days'];
		} elseif ( $this->config->get('sm_remove_credit_days')){
			$this->data['sm_remove_credit_days'] = $this->config->get('sm_remove_credit_days');
		} else {
			$this->data['sm_remove_credit_days'] = '';
		}
		
		if (isset($this->request->post['sm_remove_credit_order_status'])){
			$this->data['sm_remove_credit_order_status'] = $this->request->post['sm_remove_credit_order_status'];
		} elseif ( $this->config->get('sm_remove_credit_order_status')){
			$this->data['sm_remove_credit_order_status'] = $this->config->get('sm_remove_credit_order_status');
		} else {
			$this->data['sm_remove_credit_order_status'] = array();
		}		
		
		if (isset($this->request->post['sm_remove_credit_notification'])){
			$this->data['sm_remove_credit_notification'] = $this->request->post['sm_remove_credit_notification'];
		} elseif ( $this->config->get('sm_remove_credit_notification')){
			$this->data['sm_remove_credit_notification'] = $this->config->get('sm_remove_credit_notification');
		} else {
			$this->data['sm_remove_credit_notification'] = '';
		}		
		
		if (isset($this->request->post['sm_friend_reward_type'])){
			$this->data['sm_friend_reward_type'] = $this->request->post['sm_friend_reward_type'];
		} elseif ( $this->config->get('sm_friend_reward_type')){
			$this->data['sm_friend_reward_type'] = $this->config->get('sm_friend_reward_type');
		} else {
			$this->data['sm_friend_reward_type'] = '';
		}
		
		if (isset($this->request->post['sm_friend_reward'])){
			$this->data['sm_friend_reward'] = $this->request->post['sm_friend_reward'];
		} elseif ( $this->config->get('sm_friend_reward')){
			$this->data['sm_friend_reward'] = $this->config->get('sm_friend_reward');
		} else {
			$this->data['sm_friend_reward'] = '';
		}
		
		if (isset($this->request->post['sm_friend_order_behaviour'])){
			$this->data['sm_friend_order_behaviour'] = $this->request->post['sm_friend_order_behaviour'];
		} elseif ( $this->config->get('sm_friend_order_behaviour')){
			$this->data['sm_friend_order_behaviour'] = $this->config->get('sm_friend_order_behaviour');
		} else {
			$this->data['sm_friend_order_behaviour'] = '';
		}			
		
		if (isset($this->request->post['sm_order_final_status'])){
			$this->data['sm_order_final_status'] = $this->request->post['sm_order_final_status'];
		} elseif ( $this->config->get('sm_order_final_status')){
			$this->data['sm_order_final_status'] = $this->config->get('sm_order_final_status');
		} else {
			$this->data['sm_order_final_status'] = array();
		}
		
		if (isset($this->request->post['sm_limit_share_reward'])){
			$this->data['sm_limit_share_reward'] = $this->request->post['sm_limit_share_reward'];
		} elseif ( $this->config->get('sm_limit_share_reward')){
			$this->data['sm_limit_share_reward'] = $this->config->get('sm_limit_share_reward');
		} else {
			$this->data['sm_limit_share_reward'] = '';
		}
		
		if (isset($this->request->post['sm_fb_fan_page'])){
			$this->data['sm_fb_fan_page'] = $this->request->post['sm_fb_fan_page'];
		} elseif ( $this->config->get('sm_fb_fan_page')){
			$this->data['sm_fb_fan_page'] = $this->config->get('sm_fb_fan_page');
		} else {
			$this->data['sm_fb_fan_page'] = '';
		}
		
		if (isset($this->request->post['sm_admin_log'])){
			$this->data['sm_admin_log'] = $this->request->post['sm_admin_log'];
		} elseif ( $this->config->get('sm_admin_log')){
			$this->data['sm_admin_log'] = $this->config->get('sm_admin_log');
		} else {
			$this->data['sm_admin_log'] = '';
		}
		
		if (isset($this->request->post['sm_phone_address_required'])){
			$this->data['sm_phone_address_required'] = $this->request->post['sm_phone_address_required'];
		} elseif ( $this->config->get('sm_phone_address_required')){
			$this->data['sm_phone_address_required'] = $this->config->get('sm_phone_address_required');
		} else {
			$this->data['sm_phone_address_required'] = '';
		}		
		
		if (isset($this->request->post['sm_rules'])){
			$this->data['sm_rules'] = $this->request->post['sm_rules'];
		} elseif ( $this->config->get('sm_rules')){
			$this->data['sm_rules'] = $this->config->get('sm_rules');
		} else {
			$this->data['sm_rules'] = '';
		}
		
		$this->data['modules'] = array();
		
		if (isset($this->request->post['sales_motivator_module'])) {
			$this->data['modules'] = $this->request->post['sales_motivator_module'];
		} elseif ($this->config->get('sales_motivator_module')) { 
			$this->data['modules'] = $this->config->get('sales_motivator_module');
		}
		
		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		$this->load->model('localisation/order_status');
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
						
		$this->load->model('design/layout');
		$this->data['layouts'] = $this->model_design_layout->getLayouts();
		
		$this->data['token'] = $this->session->data['token'];
						 
		$this->template = 'module/sales_motivator.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	
	private function validate() {
	
		if (!$this->user->hasPermission('modify', 'module/sales_motivator')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$dinamic_strlen = 'utf8_strlen';
		 
		if ( !function_exists('utf8_strlen') ) {
			$dinamic_strlen = 'strlen';
		}
		
		if ($dinamic_strlen($this->request->post['sm_secret_code']) == 0){
			$this->error['secret_code'] = $this->language->get('error_secret_code');
		}
		
		if ($dinamic_strlen($this->request->post['sm_fb_app_id']) == 0){
			$this->error['fb_app_id'] = $this->language->get('error_fb_app_id');
		}
		
		if ($dinamic_strlen($this->request->post['sm_share_reward']) == 0){
			$this->error['share_reward'] = $this->language->get('error_share_reward');
		}
		
		if ($this->request->post['sm_remove_credit_status']) {
			if ($dinamic_strlen($this->request->post['sm_remove_credit_days']) == 0  || !is_numeric($this->request->post['sm_remove_credit_days'])) {
				$this->error['remove_credit_days'] = $this->language->get('remove_credit_days');
			}
			
			if (!isset($this->request->post['sm_remove_credit_order_status']) || count($this->request->post['sm_remove_credit_order_status']) < 1){
				$this->error['remove_credit_order_status'] = $this->language->get('error_remove_credit_order_status');
			}
		}
		
		if ($dinamic_strlen($this->request->post['sm_friend_reward']) == 0){
			$this->error['friend_reward'] = $this->language->get('error_friend_reward');
		}
		
		if (!isset($this->request->post['sm_order_final_status']) || count($this->request->post['sm_order_final_status']) < 1){
			$this->error['order_final_status'] = $this->language->get('error_order_final_status');
		}
				
		if ($dinamic_strlen($this->request->post['sm_limit_share_reward']) > 0 && !is_numeric($this->request->post['sm_limit_share_reward']) ){
			$this->error['limit_share_reward'] = $this->language->get('error_limit_share_reward');
		}		

		foreach ($this->request->post['sm_rules'] as $language_id => $value) {
			if ($dinamic_strlen($value['description']) < 1) {
        		$this->error['rules'][$language_id] = $this->language->get('error_rules');
        		$this->error['warning'] = $this->language->get('error_rules_general');
      		}
		}		
				
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>