<?php
class ControllerModuleRegistrationBonus extends Controller {
	private $error = array(); 
		
	public function index() {   
		$this->load->language('module/registration_bonus');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('registration_bonus', $this->request->post);		
					
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				 
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_mail'] = $this->language->get('tab_mail');
		$this->data['tab_help'] = $this->language->get('tab_help');
		
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_no_bonus_send_mail'] = $this->language->get('text_no_bonus_send_mail');
		$this->data['text_no_bonus_no_send_mail'] = $this->language->get('text_no_bonus_no_send_mail');
		
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_credit_amount'] = $this->language->get('entry_credit_amount');
		$this->data['entry_ip_check'] = $this->language->get('entry_ip_check');
		$this->data['entry_duplicate_behaviour'] = $this->language->get('entry_duplicate_behaviour');
		$this->data['entry_bonus_mail_subject'] = $this->language->get('entry_bonus_mail_subject');
		$this->data['entry_bonus_mail_message'] = $this->language->get('entry_bonus_mail_message');
		$this->data['entry_mr_mail_subject'] = $this->language->get('entry_mr_mail_subject');
		$this->data['entry_mr_mail_message'] = $this->language->get('entry_mr_mail_message');		
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['credit_amount'])) {
			$this->data['error_credit_amount'] = $this->error['credit_amount'];
		} else {
			$this->data['error_credit_amount'] = array();
		}
		
		if (isset($this->error['bonus_mail_subject'])) {
			$this->data['error_bonus_mail_subject'] = $this->error['bonus_mail_subject'];
		} else {
			$this->data['error_bonus_mail_subject'] = array();
		}
		
		if (isset($this->error['bonus_mail_message'])) {
			$this->data['error_bonus_mail_message'] = $this->error['bonus_mail_message'];
		} else {
			$this->data['error_bonus_mail_message'] = array();
		}
		
		if (isset($this->error['mr_mail_subject'])) {
			$this->data['error_mr_mail_subject'] = $this->error['mr_mail_subject'];
		} else {
			$this->data['error_mr_mail_subject'] = array();
		}
		
		if (isset($this->error['mr_mail_message'])) {
			$this->data['error_mr_mail_message'] = $this->error['mr_mail_message'];
		} else {
			$this->data['error_mr_mail_message'] = array();
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/registration_bonus', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/registration_bonus', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['registration_bonus_status'])){
			$this->data['registration_bonus_status'] = $this->request->post['registration_bonus_status'];
		} elseif ( $this->config->get('registration_bonus_status')){
			$this->data['registration_bonus_status'] = $this->config->get('registration_bonus_status');
		} else {
			$this->data['registration_bonus_status'] = '';
		}
		
		if (isset($this->request->post['registration_bonus_credit_amount'])){
			$this->data['registration_bonus_credit_amount'] = $this->request->post['registration_bonus_credit_amount'];
		} elseif ( $this->config->get('registration_bonus_credit_amount')){
			$this->data['registration_bonus_credit_amount'] = $this->config->get('registration_bonus_credit_amount');
		} else {
			$this->data['registration_bonus_credit_amount'] = '';
		}
		
		if (isset($this->request->post['registration_bonus_ip_check'])){
			$this->data['registration_bonus_ip_check'] = $this->request->post['registration_bonus_ip_check'];
		} elseif ( $this->config->get('registration_bonus_ip_check')){
			$this->data['registration_bonus_ip_check'] = $this->config->get('registration_bonus_ip_check');
		} else {
			$this->data['registration_bonus_ip_check'] = '';
		}
		
		if (isset($this->request->post['registration_bonus_duplicate_behaviour'])){
			$this->data['registration_bonus_duplicate_behaviour'] = $this->request->post['registration_bonus_duplicate_behaviour'];
		} elseif ( $this->config->get('registration_bonus_duplicate_behaviour')){
			$this->data['registration_bonus_duplicate_behaviour'] = $this->config->get('registration_bonus_duplicate_behaviour');
		} else {
			$this->data['registration_bonus_duplicate_behaviour'] = '';
		}
		
		if (isset($this->request->post['registration_bonus_mail'])){
			$this->data['registration_bonus_mail'] = $this->request->post['registration_bonus_mail'];
		} elseif ( $this->config->get('registration_bonus_mail')){
			$this->data['registration_bonus_mail'] = $this->config->get('registration_bonus_mail');
		} else {
			$this->data['registration_bonus_mail'] = '';
		}
		
		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		$this->data['token'] = $this->session->data['token'];
						 
		$this->template = 'module/registration_bonus.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
	
		if (!$this->user->hasPermission('modify', 'module/registration_bonus')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$dinamic_strlen = 'utf8_strlen';
		 
		if ( !function_exists('utf8_strlen') ) {
			$dinamic_strlen = 'strlen';
		}
		
		if ($dinamic_strlen($this->request->post['registration_bonus_credit_amount']) == 0 || $this->request->post['registration_bonus_credit_amount'] < 1){
			$this->error['credit_amount'] = $this->language->get('error_credit_amount');
		}		

		foreach ($this->request->post['registration_bonus_mail'] as $language_id => $value) {
			if ($dinamic_strlen($value['bonus_mail_subject']) < 1) {
        		$this->error['bonus_mail_subject'][$language_id] = $this->language->get('error_bonus_mail_subject');
      		}
			
			if ($dinamic_strlen($value['bonus_mail_message']) < 1) {
        		$this->error['bonus_mail_message'][$language_id] = $this->language->get('error_bonus_mail_message');
      		}
			
			if ($dinamic_strlen($value['mr_mail_subject']) < 1) {
        		$this->error['mr_mail_subject'][$language_id] = $this->language->get('error_mr_mail_subject');
      		}
			
			if ($dinamic_strlen($value['mr_mail_message']) < 1) {
        		$this->error['mr_mail_message'][$language_id] = $this->language->get('error_mr_mail_message');
      		}
		}		
				
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>