<?php
class ControllerModuleHTMLEmail extends Controller {
	private $error = array(); 
	private $version = '1.2.1.2';
	
	public function saveSettings() {
		$this->load->language('module/html_email');
		
		$this->load->model('setting/setting');
		
		$json = array();
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			$this->model_setting_setting->editSetting('html_email', $this->request->post);		
					
			$json['success'] = $this->language->get('text_success');
		
		} else {
			$json['error'] = $this->error;
		}		
		
		$this->response->setOutput(json_encode($json));
  	}
	
	public function index() {   
		$this->load->language('module/html_email');

		$this->load->model('tool/image');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->document->addScript('view/javascript/jquery/colorpicker/colorpicker.js');
		$this->document->addStyle('view/stylesheet/colorpicker.css');
		$this->document->addStyle('view/stylesheet/html_email.css');
				 
		$this->data['heading_title'] = $this->language->get('heading_title') . ' ' . $this->version;
		
		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_template'] = $this->language->get('tab_template');
		$this->data['tab_email_page'] = $this->language->get('tab_email_page');
		$this->data['tab_email_top_bar'] = $this->language->get('tab_email_top_bar');
		$this->data['tab_email_header'] = $this->language->get('tab_email_header');
		$this->data['tab_email_featured'] = $this->language->get('tab_email_featured');
		$this->data['tab_email_main'] = $this->language->get('tab_email_main');
		$this->data['tab_email_footer'] = $this->language->get('tab_email_footer');
		$this->data['tab_email_subfooter'] = $this->language->get('tab_email_subfooter');
		$this->data['tab_help'] = $this->language->get('tab_help');
		
		$this->data['text_layout_preview'] = $this->language->get('text_layout_preview');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		
		$this->data['text_send_test'] = $this->language->get('text_send_test');
		
		$this->data['entry_background_color'] = $this->language->get('entry_background_color');
		$this->data['entry_text_color'] = $this->language->get('entry_text_color');
		$this->data['entry_link_color'] = $this->language->get('entry_link_color');	
		$this->data['entry_table_border_color'] = $this->language->get('entry_table_border_color');	
		$this->data['entry_table_header_bg'] = $this->language->get('entry_table_header_bg');	
		$this->data['entry_table_header_text_color'] = $this->language->get('entry_table_header_text_color');	
		$this->data['entry_table_body_bg'] = $this->language->get('entry_table_body_bg');	
		$this->data['entry_table_body_text_color'] = $this->language->get('entry_table_body_text_color');	
		$this->data['entry_logo'] = $this->language->get('entry_logo');	
		$this->data['entry_logo_dimension'] = $this->language->get('entry_logo_dimension');	
		$this->data['entry_fb_link'] = $this->language->get('entry_fb_link');	
		$this->data['entry_twitter_link'] = $this->language->get('entry_twitter_link');	
		$this->data['entry_youtube_link'] = $this->language->get('entry_youtube_link');	
		$this->data['entry_fb_icon'] = $this->language->get('entry_fb_icon');	
		$this->data['entry_tw_icon'] = $this->language->get('entry_tw_icon');	
		$this->data['entry_yt_icon'] = $this->language->get('entry_yt_icon');
		$this->data['entry_show_featured'] = $this->language->get('entry_show_featured');
		$this->data['entry_show_footer'] = $this->language->get('entry_show_footer');
			
		$this->data['entry_email'] = $this->language->get('entry_email');	
		
		// language messages
		$this->data['entry_view_store'] = $this->language->get('entry_view_store');
		$this->data['entry_contact_us'] = $this->language->get('entry_contact_us');
		$this->data['entry_my_account'] = $this->language->get('entry_my_account');
		$this->data['entry_featured_title'] = $this->language->get('entry_featured_title');
		$this->data['entry_featured_description'] = $this->language->get('entry_featured_description');
		$this->data['entry_featured_link'] = $this->language->get('entry_featured_link');
		$this->data['entry_featured_find_more_info'] = $this->language->get('entry_featured_find_more_info');
		$this->data['entry_footer_description'] = $this->language->get('entry_footer_description');	
		$this->data['entry_copyright'] = $this->language->get('entry_copyright');	
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		
		$this->data['button_send_test'] = $this->language->get('button_send_test');
		$this->data['button_send_now'] = $this->language->get('button_send_now');
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/html_email', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/html_email', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['html_email_default_word'])){
			$this->data['html_email_default_word'] = $this->request->post['html_email_default_word'];
		} elseif ( $this->config->get('html_email_default_word')){
			$this->data['html_email_default_word'] = $this->config->get('html_email_default_word');
		} else {
			$this->data['html_email_default_word'] = array();
		}
		
		if (isset($this->request->post['html_email_page_bg'])){
			$this->data['html_email_page_bg'] = $this->request->post['html_email_page_bg'];
		} elseif ( $this->config->get('html_email_page_bg')){
			$this->data['html_email_page_bg'] = $this->config->get('html_email_page_bg');
		} else {
			$this->data['html_email_page_bg'] = '#EFEFEF';
		}
		
		if (isset($this->request->post['html_email_top_bar_bg'])){
			$this->data['html_email_top_bar_bg'] = $this->request->post['html_email_top_bar_bg'];
		} elseif ( $this->config->get('html_email_top_bar_bg')){
			$this->data['html_email_top_bar_bg'] = $this->config->get('html_email_top_bar_bg');
		} else {
			$this->data['html_email_top_bar_bg'] = '#484848';
		}
		
		if (isset($this->request->post['html_email_top_bar_text_color'])){
			$this->data['html_email_top_bar_text_color'] = $this->request->post['html_email_top_bar_text_color'];
		} elseif ( $this->config->get('html_email_top_bar_text_color')){
			$this->data['html_email_top_bar_text_color'] = $this->config->get('html_email_top_bar_text_color');
		} else {
			$this->data['html_email_top_bar_text_color'] = '#D8D8D8';
		}
		
		if (isset($this->request->post['html_email_top_bar_link_color'])){
			$this->data['html_email_top_bar_link_color'] = $this->request->post['html_email_top_bar_link_color'];
		} elseif ( $this->config->get('html_email_top_bar_link_color')){
			$this->data['html_email_top_bar_link_color'] = $this->config->get('html_email_top_bar_link_color');
		} else {
			$this->data['html_email_top_bar_link_color'] = '#FFFFFF';
		}
		
		if (isset($this->request->post['html_email_header_bg'])){
			$this->data['html_email_header_bg'] = $this->request->post['html_email_header_bg'];
		} elseif ( $this->config->get('html_email_header_bg')){
			$this->data['html_email_header_bg'] = $this->config->get('html_email_header_bg');
		} else {
			$this->data['html_email_header_bg'] = '#FFFFFF';
		}
		
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		
		if (isset($this->request->post['html_email_logo'])){
			$this->data['html_email_logo'] = $this->request->post['html_email_logo'];
		} elseif ( $this->config->get('html_email_logo')){
			$this->data['html_email_logo'] = $this->config->get('html_email_logo');
		} else {
			$this->data['html_email_logo'] = '';
		}
		
		if ($this->config->get('html_email_logo') && file_exists(DIR_IMAGE . $this->config->get('html_email_logo')) && is_file(DIR_IMAGE . $this->config->get('html_email_logo'))) {
			$this->data['logo'] = $this->model_tool_image->resize($this->config->get('html_email_logo'), 100, 100);		
		} else {
			$this->data['logo'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}
		
		if (isset($this->request->post['html_email_logo_width'])){
			$this->data['html_email_logo_width'] = $this->request->post['html_email_logo_width'];
		} elseif ( $this->config->get('html_email_logo_width')){
			$this->data['html_email_logo_width'] = $this->config->get('html_email_logo_width');
		} else {
			$this->data['html_email_logo_width'] = '';
		}
		
		if (isset($this->request->post['html_email_logo_height'])){
			$this->data['html_email_logo_height'] = $this->request->post['html_email_logo_height'];
		} elseif ( $this->config->get('html_email_logo_height')){
			$this->data['html_email_logo_height'] = $this->config->get('html_email_logo_height');
		} else {
			$this->data['html_email_logo_height'] = '';
		}
		
		if (isset($this->request->post['html_email_fb_link'])){
			$this->data['html_email_fb_link'] = $this->request->post['html_email_fb_link'];
		} elseif ( $this->config->get('html_email_fb_link')){
			$this->data['html_email_fb_link'] = $this->config->get('html_email_fb_link');
		} else {
			$this->data['html_email_fb_link'] = '';
		}
		
		if (isset($this->request->post['html_email_tw_link'])){
			$this->data['html_email_tw_link'] = $this->request->post['html_email_tw_link'];
		} elseif ( $this->config->get('html_email_tw_link')){
			$this->data['html_email_tw_link'] = $this->config->get('html_email_tw_link');
		} else {
			$this->data['html_email_tw_link'] = '';
		}
		
		if (isset($this->request->post['html_email_yt_link'])){
			$this->data['html_email_yt_link'] = $this->request->post['html_email_yt_link'];
		} elseif ( $this->config->get('html_email_yt_link')){
			$this->data['html_email_yt_link'] = $this->config->get('html_email_yt_link');
		} else {
			$this->data['html_email_yt_link'] = '';
		}
		
		$this->data['no_facebook_icon'] = $this->model_tool_image->resize('data/html_email_social/facebook.png', 32, 32);
		
		if (isset($this->request->post['html_email_facebook_icon'])){
			$this->data['html_email_facebook_icon'] = $this->request->post['html_email_facebook_icon'];
		} elseif ( $this->config->get('html_email_facebook_icon')){
			$this->data['html_email_facebook_icon'] = $this->config->get('html_email_facebook_icon');
		} else {
			$this->data['html_email_facebook_icon'] = 'data/html_email_social/facebook.png';
		}
		
		if ($this->config->get('html_email_facebook_icon') && file_exists(DIR_IMAGE . $this->config->get('html_email_facebook_icon')) && is_file(DIR_IMAGE . $this->config->get('html_email_facebook_icon'))) {
			$this->data['facebook_icon'] = $this->model_tool_image->resize($this->config->get('html_email_facebook_icon'), 32, 32);		
		} else {
			$this->data['facebook_icon'] = $this->model_tool_image->resize('data/html_email_social/facebook.png', 32, 32);
		}		
		
		$this->data['no_twitter_icon'] = $this->model_tool_image->resize('data/html_email_social/twitter.png', 32, 32);
		
		if (isset($this->request->post['html_email_twitter_icon'])){
			$this->data['html_email_twitter_icon'] = $this->request->post['html_email_twitter_icon'];
		} elseif ( $this->config->get('html_email_twitter_icon')){
			$this->data['html_email_twitter_icon'] = $this->config->get('html_email_twitter_icon');
		} else {
			$this->data['html_email_twitter_icon'] = 'data/html_email_social/twitter.png';
		}
		
		if ($this->config->get('html_email_twitter_icon') && file_exists(DIR_IMAGE . $this->config->get('html_email_twitter_icon')) && is_file(DIR_IMAGE . $this->config->get('html_email_twitter_icon'))) {
			$this->data['twitter_icon'] = $this->model_tool_image->resize($this->config->get('html_email_twitter_icon'), 32, 32);		
		} else {
			$this->data['twitter_icon'] = $this->model_tool_image->resize('data/html_email_social/twitter.png', 32, 32);
		}
		
		$this->data['no_youtube_icon'] = $this->model_tool_image->resize('data/html_email_social/youtube.png', 32, 32);
		
		if (isset($this->request->post['html_email_youtube_icon'])){
			$this->data['html_email_youtube_icon'] = $this->request->post['html_email_youtube_icon'];
		} elseif ( $this->config->get('html_email_youtube_icon')){
			$this->data['html_email_youtube_icon'] = $this->config->get('html_email_youtube_icon');
		} else {
			$this->data['html_email_youtube_icon'] = 'data/html_email_social/youtube.png';
		}
		
		if ($this->config->get('html_email_youtube_icon') && file_exists(DIR_IMAGE . $this->config->get('html_email_youtube_icon')) && is_file(DIR_IMAGE . $this->config->get('html_email_youtube_icon'))) {
			$this->data['youtube_icon'] = $this->model_tool_image->resize($this->config->get('html_email_youtube_icon'), 32, 32);		
		} else {
			$this->data['youtube_icon'] = $this->model_tool_image->resize('data/html_email_social/youtube.png', 32, 32);
		}
		
		if (isset($this->request->post['html_email_show_featured'])){
			$this->data['html_email_show_featured'] = $this->request->post['html_email_show_featured'];
		} elseif ($this->config->get('html_email_show_featured')){
			$this->data['html_email_show_featured'] = $this->config->get('html_email_show_featured');
		} else {
			$this->data['html_email_show_featured'] = '';
		}
		
		if (isset($this->request->post['html_email_featured_bg'])){
			$this->data['html_email_featured_bg'] = $this->request->post['html_email_featured_bg'];
		} elseif ( $this->config->get('html_email_featured_bg')){
			$this->data['html_email_featured_bg'] = $this->config->get('html_email_featured_bg');
		} else {
			$this->data['html_email_featured_bg'] = '#3498DB';
		}
		
		if (isset($this->request->post['html_email_featured_text_color'])){
			$this->data['html_email_featured_text_color'] = $this->request->post['html_email_featured_text_color'];
		} elseif ( $this->config->get('html_email_featured_text_color')){
			$this->data['html_email_featured_text_color'] = $this->config->get('html_email_featured_text_color');
		} else {
			$this->data['html_email_featured_text_color'] = '#FFFFFF';
		}
		
		if (isset($this->request->post['html_email_featured_link_color'])){
			$this->data['html_email_featured_link_color'] = $this->request->post['html_email_featured_link_color'];
		} elseif ( $this->config->get('html_email_featured_link_color')){
			$this->data['html_email_featured_link_color'] = $this->config->get('html_email_featured_link_color');
		} else {
			$this->data['html_email_featured_link_color'] = '#FFFFFF';
		}
		
		if (isset($this->request->post['html_email_main_bg'])){
			$this->data['html_email_main_bg'] = $this->request->post['html_email_main_bg'];
		} elseif ( $this->config->get('html_email_main_bg')){
			$this->data['html_email_main_bg'] = $this->config->get('html_email_main_bg');
		} else {
			$this->data['html_email_main_bg'] = '#FFFFFF';
		}
		
		if (isset($this->request->post['html_email_main_text_color'])){
			$this->data['html_email_main_text_color'] = $this->request->post['html_email_main_text_color'];
		} elseif ( $this->config->get('html_email_main_text_color')){
			$this->data['html_email_main_text_color'] = $this->config->get('html_email_main_text_color');
		} else {
			$this->data['html_email_main_text_color'] = '#696969';
		}
		
		if (isset($this->request->post['html_email_main_link_color'])){
			$this->data['html_email_main_link_color'] = $this->request->post['html_email_main_link_color'];
		} elseif ( $this->config->get('html_email_main_link_color')){
			$this->data['html_email_main_link_color'] = $this->config->get('html_email_main_link_color');
		} else {
			$this->data['html_email_main_link_color'] = '#696969';
		}
		
		if (isset($this->request->post['html_email_main_table_border_color'])){
			$this->data['html_email_main_table_border_color'] = $this->request->post['html_email_main_table_border_color'];
		} elseif ( $this->config->get('html_email_main_table_border_color')){
			$this->data['html_email_main_table_border_color'] = $this->config->get('html_email_main_table_border_color');
		} else {
			$this->data['html_email_main_table_border_color'] = '#DDDDDD';
		}
		
		if (isset($this->request->post['html_email_main_table_header_bg'])){
			$this->data['html_email_main_table_header_bg'] = $this->request->post['html_email_main_table_header_bg'];
		} elseif ( $this->config->get('html_email_main_table_header_bg')){
			$this->data['html_email_main_table_header_bg'] = $this->config->get('html_email_main_table_header_bg');
		} else {
			$this->data['html_email_main_table_header_bg'] = '#EFEFEF';
		}
		
		if (isset($this->request->post['html_email_main_table_header_text_color'])){
			$this->data['html_email_main_table_header_text_color'] = $this->request->post['html_email_main_table_header_text_color'];
		} elseif ( $this->config->get('html_email_main_table_header_text_color')){
			$this->data['html_email_main_table_header_text_color'] = $this->config->get('html_email_main_table_header_text_color');
		} else {
			$this->data['html_email_main_table_header_text_color'] = '#222222';
		}
		
		if (isset($this->request->post['html_email_main_table_body_bg'])){
			$this->data['html_email_main_table_body_bg'] = $this->request->post['html_email_main_table_body_bg'];
		} elseif ( $this->config->get('html_email_main_table_body_bg')){
			$this->data['html_email_main_table_body_bg'] = $this->config->get('html_email_main_table_body_bg');
		} else {
			$this->data['html_email_main_table_body_bg'] = '#FFFFFF';
		}
		
		if (isset($this->request->post['html_email_main_table_body_text_color'])){
			$this->data['html_email_main_table_body_text_color'] = $this->request->post['html_email_main_table_body_text_color'];
		} elseif ( $this->config->get('html_email_main_table_body_text_color')){
			$this->data['html_email_main_table_body_text_color'] = $this->config->get('html_email_main_table_body_text_color');
		} else {
			$this->data['html_email_main_table_body_text_color'] = '#696969';
		}
		
		if (isset($this->request->post['html_email_show_footer'])){
			$this->data['html_email_show_footer'] = $this->request->post['html_email_show_footer'];
		} elseif ($this->config->get('html_email_show_footer')){
			$this->data['html_email_show_footer'] = $this->config->get('html_email_show_footer');
		} else {
			$this->data['html_email_show_footer'] = '';
		}
		
		if (isset($this->request->post['html_email_footer_bg'])){
			$this->data['html_email_footer_bg'] = $this->request->post['html_email_footer_bg'];
		} elseif ( $this->config->get('html_email_footer_bg')){
			$this->data['html_email_footer_bg'] = $this->config->get('html_email_footer_bg');
		} else {
			$this->data['html_email_footer_bg'] = '#545454';
		}
		
		if (isset($this->request->post['html_email_footer_text_color'])){
			$this->data['html_email_footer_text_color'] = $this->request->post['html_email_footer_text_color'];
		} elseif ( $this->config->get('html_email_footer_text_color')){
			$this->data['html_email_footer_text_color'] = $this->config->get('html_email_footer_text_color');
		} else {
			$this->data['html_email_footer_text_color'] = '#D8D8D8';
		}
		
		if (isset($this->request->post['html_email_footer_link_color'])){
			$this->data['html_email_footer_link_color'] = $this->request->post['html_email_footer_link_color'];
		} elseif ( $this->config->get('html_email_footer_link_color')){
			$this->data['html_email_footer_link_color'] = $this->config->get('html_email_footer_link_color');
		} else {
			$this->data['html_email_footer_link_color'] = '#FFFFFF';
		}
		
		if (isset($this->request->post['html_email_subfooter_bg'])){
			$this->data['html_email_subfooter_bg'] = $this->request->post['html_email_subfooter_bg'];
		} elseif ( $this->config->get('html_email_subfooter_bg')){
			$this->data['html_email_subfooter_bg'] = $this->config->get('html_email_subfooter_bg');
		} else {
			$this->data['html_email_subfooter_bg'] = '#484848';
		}
		
		if (isset($this->request->post['html_email_subfooter_text_color'])){
			$this->data['html_email_subfooter_text_color'] = $this->request->post['html_email_subfooter_text_color'];
		} elseif ( $this->config->get('html_email_subfooter_text_color')){
			$this->data['html_email_subfooter_text_color'] = $this->config->get('html_email_subfooter_text_color');
		} else {
			$this->data['html_email_subfooter_text_color'] = '#D8D8D8';
		}
		
		$this->data['default_email'] = $this->config->get('config_email');
		
		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		$this->data['token'] = $this->session->data['token'];
						 
		$this->template = 'module/html_email.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
	
		if (!$this->user->hasPermission('modify', 'module/html_email')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$dinamic_strlen = 'utf8_strlen';
		 
		if ( !function_exists('utf8_strlen') ) {
			$dinamic_strlen = 'strlen';
		}
		
		if (isset($this->request->post['html_email_default_word'])) {
			foreach ($this->request->post['html_email_default_word'] as $language_id => $value) {
				if ($dinamic_strlen($value['view_store']) < 1) {
					$this->error['view_store'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['contact_us']) < 1) {
					$this->error['contact_us'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['my_account']) < 1) {
					$this->error['my_account'][$language_id] = $this->language->get('error_required');
				}

				if ($dinamic_strlen($value['featured_title']) < 1) {
					$this->error['featured_title'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['featured_description']) < 1) {
					$this->error['featured_description'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['find_more_info']) < 1) {
					$this->error['find_more_info'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['featured_link']) < 1) {
					$this->error['featured_link'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['footer_description']) < 1) {
					$this->error['footer_description'][$language_id] = $this->language->get('error_required');
				}
				
				if ($dinamic_strlen($value['copyright']) < 1) {
					$this->error['copyright'][$language_id] = $this->language->get('error_required');
				}
			}
		}	
				
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
	
	public function sendTestEmail() {
		$this->load->language('module/html_email');
		
		$this->load->model('tool/html_email');
		
		$json = array();
				
		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if (!$this->user->hasPermission('modify', 'module/html_email')) {
				$json['error']['warning'] = $this->language->get('error_permission');
			}
			
			$dinamic_strlen = 'utf8_strlen';
		 
			if ( !function_exists('utf8_strlen') ) {
				$dinamic_strlen = 'strlen';
			}
					
			if (!$this->request->post['emails']) {
				$json['error']['warning'] = $this->language->get('error_required');
			
			} else {
				
				$emails = explode(",", $this->request->post['emails']);
				
				foreach($emails as $email) {
					if (($dinamic_strlen(trim($email)) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', trim($email))) {
						$json['error']['warning'] = $this->language->get('error_email_wrong_format');
					}
				}
			}
			
			if (!$json) {
			
				$template = new Template();
				
				$template->data['table_border_color'] = $this->config->get('html_email_main_table_border_color');		
				$template->data['table_header_bg'] = $this->config->get('html_email_main_table_header_bg');		
				$template->data['table_header_text_color'] = $this->config->get('html_email_main_table_header_text_color');		
				$template->data['table_body_bg'] = $this->config->get('html_email_main_table_body_bg');		
				$template->data['table_body_text_color'] = $this->config->get('html_email_main_table_body_text_color');
						
				$subject = $this->language->get('text_subject');
				
				$html = $this->model_tool_html_email->getHTMLEmail($this->config->get('config_language_id'), $subject, $template->fetch('mail/html_email_test.tpl'), 'html');
				
				$mail = new Mail();	
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender($this->config->get('config_name'));
				$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
					
				foreach ($emails as $email) {
					$mail->setTo($email);					
					$mail->setHtml($html);
					$mail->send();
				}
				
				$json['success'] = $this->language->get('text_success_test_email');
			}
		}
		
		$this->response->setOutput(json_encode($json));
  	} 
}
?>