<?php   

//==============================================================================
// pincode extention
// Author: Onjection Solutions
// E-mail: tomas@onjection.com
// Website: http://www.onjection.com
//==============================================================================

class ControllerCommonpincode extends Controller {   
	public function index() {
		$this->load->model('catalog/pincode');
		$status = $this->model_catalog_pincode->install_status();
		if($status['total'] > 0){
			$this->language->load('common/pincode');
			$this->document->setTitle($this->language->get('heading_title'));
			$this->data['heading_title'] = $this->language->get('heading_title');
			
			$this->language->load('common/pincode');
			$this->load->model('catalog/pincode');
			
			
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
				} else {
				$page = 1;
			}
			$data = array(
				'start' => ($page - 1) * $this->config->get('config_admin_limit'),
				'limit' => $this->config->get('config_admin_limit')
			);
			
			$url = '';
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$select = "";
			if(isset($_GET['myselect'])){
				$select = "WHERE p.service_available =".$_GET['myselect'];
				$downloadcsv = $this->url->link('common/pincode/download', 'token=' . $this->session->data['token']."&myselect=".$_GET['myselect']. $url, 'SSL');
			}
			else{
				$downloadcsv = $this->url->link('common/pincode/download', 'token=' . $this->session->data['token']. $url, 'SSL');
			}
			$this->data['downloadcsv']= $downloadcsv;
			
			$picodes = $this->model_catalog_pincode->getmypin($data,$select);
			$count = $this->model_catalog_pincode->pincount($select);
			
			$no_rows[] = $count;
			$pin_code[] = $picodes;
			$this->data['pincode'] = $pin_code;
			$this->data['count'] = $no_rows;
			$pins = array();
			
			foreach ($picodes as $result) {
				$this->data['pincodes'][] = array(
					'pin' => $result['pincode'],
					'service' => $result['service_available'],
					'id'  => $result['id'],
					'delivery'  => $result['delivery_time']
				);
			}
			
			if(isset($_GET['editpin'])){
				$this->data['delivery_time'] = $this->model_catalog_pincode->getmydelivery();
				$pinid = $_GET['editpin'];
				$pin_cod = $this->model_catalog_pincode->editmypin($pinid);
				$pins[] = $pin_cod;
				$this->data['pin_code'] = $pins;
			}
			
				
			$pagination = new Pagination();
			$pagination->total = $no_rows[0]['count(*)'];
			$pagination->page = $page;
			$pagination->limit = $this->config->get('config_admin_limit');
			$pagination->text = $this->language->get('text_pagination');
			if(isset($_GET['myselect'])){
				$pagination->url = $this->url->link('common/pincode', 'token=' . $this->session->data['token'] . '&allpin=1&myselect='.$_GET['myselect'].'&page={page}', 'SSL');
			}
			else{
				$pagination->url = $this->url->link('common/pincode', 'token=' . $this->session->data['token'] . '&allpin=1&page={page}', 'SSL');
			}
			$this->data['pagination'] = $pagination->render();
			
			$this->template = 'common/pincode.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
			$this->response->setOutput($this->render());
		} else {
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
  	}
	
	public function support(){
		$this->template = 'common/pincode_support.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
		$this->response->setOutput($this->render());
	}
	public function setting(){
		$this->load->model('catalog/pincode');
		$status = $this->model_catalog_pincode->install_status();
		if($status['total'] > 0){
			if(isset($_POST['pincode_checkout_status'])){
				$this->load->model('setting/setting');
				$this->model_setting_setting->editSetting('pcheckout', $this->request->post);
				$this->redirect($this->url->link('common/pincode/setting', 'token=' . $this->session->data['token'], 'SSL')); 
			}
			
			$this->template = 'common/pincode_setting.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
			$this->response->setOutput($this->render());
		} else {
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
	}
	
	public function insert(){
		$this->language->load('common/pincode');
		$this->load->model('catalog/pincode');
		$status = $this->model_catalog_pincode->install_status();
		if($status['total'] > 0){
			if($this->request->post){
				foreach($this->request->post['data'] as $data){
					$count = $this->model_catalog_pincode->checkmypin($data['pin']);
					if($count['count(*)'] == 0){
						$this->model_catalog_pincode->putmypin($data['pin'],$data['service'],$data['delivery']);
					}
				}
				$this->redirect($this->url->link('common/pincode', 'token=' . $this->session->data['token']."&allpin=1", 'SSL')); 
			}
			
			$this->data['delivery_time'] = $this->model_catalog_pincode->getmydelivery();
			
			$this->template = 'common/pincode_insert.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
			$this->response->setOutput($this->render());
		} else {
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
	}
	
	public function delete(){ 
		$this->language->load('common/pincode');
		$this->load->model('catalog/pincode');
		if (isset($this->request->post['selected'])){
			foreach ($this->request->post['selected'] as $id){
				$this->model_catalog_pincode->deletemypin($id);
			}
			$this->redirect($this->url->link('common/pincode', 'token=' . $this->session->data['token']."&allpin=1", 'SSL')); 
		}
	}
	public function update() {
		$this->load->model('catalog/pincode');
		if($this->request->post){
			$id = $_POST['id'];
			$epincode = $_POST['e_pin'];
			$eservice = $_POST['e_service'];
			$edelivery = $_POST['e_delivery'];
			$this->model_catalog_pincode->updatemypin($epincode,$eservice,$edelivery,$id);
		}
		$this->redirect($this->url->link('common/pincode', 'token=' . $this->session->data['token']."&allpin=1", 'SSL')); 
	}
	
	public function upload(){
		$this->language->load('common/pincode');
		$this->load->model('catalog/pincode');
		
		if(isset($this->request->post)){
			if ($_FILES["file_up"]["error"] > 0){
			  $this->data['warning2'] = $this->language->get('error_warning2');
			} 
			$type = $_FILES["file_up"]["type"];
			$upload_service = $_POST['upload_service'];
			$upload_delivery = $_POST['upload_delivery'];
			//if($type == 'application/vnd.ms-excel'){
				$csv_file = $_FILES["file_up"]["tmp_name"];
				if (($getfile = fopen($csv_file, "r")) !== FALSE) {
					$data = fgetcsv($getfile, 1000, ",");
					while (($data = fgetcsv($getfile, 1000, ",")) !== FALSE) {
						for ($c=0; $c < 1; $c++) {
							$result = $data;
							$str = implode(",", $result);
							$slice = explode(",", $str);
						
							$col1 = $slice[0];
							$count = $this->model_catalog_pincode->checkmypin($col1);
							if($count['count(*)'] == 0){
								$this->model_catalog_pincode->uploadfile($col1,$upload_service,$upload_delivery);
								$this->data['success1'] = $this->language->get('text_success1');
							}
							else{
								$this->model_catalog_pincode->updateuploadpin($col1,$upload_service,$upload_delivery);
								$this->data['success1'] = $this->language->get('text_success1');
								
							}
						}
					}
				}
			//}
		}
		$this->redirect($this->url->link('common/pincode', 'token=' . $this->session->data['token']."&allpin=1", 'SSL')); 
	}
	
	public function download() {
		$select = "";
		if(isset($_GET['myselect'])){
			$select = "WHERE service_available =".$_GET['myselect'];
		}
		$this->load->model('catalog/pincode');
		$item=$this->model_catalog_pincode->download_csv($select); 
		header('Content-Type: text/csv; charset=utf-8');
		header("Content-Transfer-Encoding: UTF-8");
		header('Content-Disposition: attachment; filename=Pincode.csv');
		header("Pragma: no-cache");
		header("Expires: 0");
		$output = fopen("php://output", "w");
		fputcsv($output,array('Pincode'));
		foreach ($item as $row) {
			fputcsv($output, $row);
		}
		fclose($output);
		exit();
	}
	
	public function delivery_time(){
		$this->language->load('common/pincode');
		$this->load->model('catalog/pincode');
		$status = $this->model_catalog_pincode->install_status();
		if($status['total'] > 0){
			if(isset($this->request->post['data'])){
				foreach($this->request->post['data'] as $data){
					$count = $this->model_catalog_pincode->checkmydelivery($data['delivery']);
					if($count['total'] == 0 && $data['delivery'] != ''){
						$this->model_catalog_pincode->putmydelivery($data['delivery']);
					}
				}
			}
			
			if(isset($_GET['editdelivery'])){ 
				$this->data['delivery_time'] = $this->model_catalog_pincode->editmydelivery($_GET['editdelivery']);
			} else {
				$this->data['delivery_time'] = $this->model_catalog_pincode->getmydelivery();
			}
			
			$this->template = 'common/pincode_delivery.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
			$this->response->setOutput($this->render());
		} else {
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
	}
	
	public function update_delivery(){
		if(isset($this->request->post)){
			$this->load->model('catalog/pincode');
			$this->model_catalog_pincode->updatemydelivery($this->request->post);
			$this->redirect($this->url->link('common/pincode/delivery_time', 'token=' . $this->session->data['token'], 'SSL')); 
		} else{
			$this->redirect($this->url->link('common/pincode/delivery_time', 'token=' . $this->session->data['token'], 'SSL')); 
		}
		
	}
	
	public function delete_delivery(){
		if(isset($this->request->post) && !empty($this->request->post)){
			$this->load->model('catalog/pincode');
			$this->model_catalog_pincode->deletemydelivery($this->request->post);
			$this->redirect($this->url->link('common/pincode/delivery_time', 'token=' . $this->session->data['token'], 'SSL')); 
		} else{
			$this->redirect($this->url->link('common/pincode/delivery_time', 'token=' . $this->session->data['token'], 'SSL')); 
		}
	}

}
?>