<?php
class ControllerCatalogDil extends Controller {
	private $error = array();

	public function index() {
		$this->language->load('catalog/dil');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/dil');

		$this->getList();
	} 

	public function delete() { 
		$this->language->load('catalog/dil');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/dil');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $id) {
				$this->model_catalog_dil->deleteDil($id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->redirect($this->url->link('catalog/dil', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	protected function getList() {
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$this->data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('catalog/dil', 'token=' . $this->session->data['token'] . $url, 'SSL'),
			'separator' => ' :: '
		);

		$this->data['delete'] = $this->url->link('catalog/dil/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->data['export'] = $this->url->link('catalog/dil/export', 'token=' . $this->session->data['token'] . $url, 'SSL');	

		$this->data['reviews'] = array();

		$data = array(
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);

		$review_total = $this->model_catalog_dil->getTotalDil();

		$results = $this->model_catalog_dil->getDils($data);

		foreach ($results as $result) {
			
			$this->data['reviews'][] = array(
				'id'  => $result['id'],
				'name'       => $result['name'],
				'email'     => $result['email'],
				'phone'     => $result['phone'],
				'company_name'=> $result['company_name'],
				'description'     => $result['description'],
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'selected'   => isset($this->request->post['selected']) && in_array($result['id'], $this->request->post['selected'])
			);
		}	

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_product'] = $this->language->get('column_product');
		$this->data['column_author'] = $this->language->get('column_author');
		$this->data['column_rating'] = $this->language->get('column_rating');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_action'] = $this->language->get('column_action');		

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$url = '';

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $review_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('catalog/dil', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$this->data['pagination'] = $pagination->render();

		$this->template = 'catalog/dil_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
	}
	
	public function export($getarr='') {
               
        	$data = array();
        
        $customers = array();
        
        $customers_column=array();
        
        $this->load->model('catalog/dil');
        
        $customers_column = array('Company Name', 'Name', 'Telephone', 'Email', 'Description', 'Date Added');
            
        $customers[0] = $customers_column;  
        
        $customers_list = $this->model_catalog_dil->getExportDils();
        
        foreach($customers_list as $customer_row)
        {
            $customers[] = $customer_row;
        }
        require_once(DIR_SYSTEM . 'library/excel_xml.php');
        $xls = new Excel_XML('UTF-8', false, 'DIL INFO List');
        $xls->addArray($customers);
        $xls->generateXML('DIL_INFO_List_'.date('Y-m-d _ H:i:s'));
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'catalog/dil')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}	
}
?>